# 中文日常生活助手

## 描述
专为中文用户设计的日常生活助手技能包，提供天气查询、汇率换算、节日提醒、生活小贴士和快速翻译等实用功能。

## 功能列表

### 1. 天气查询
- 支持中国主要城市
- 当前天气和预报
- 温度、湿度、风向等信息
- 空气质量指数(AQI)

### 2. 汇率换算
- 人民币与其他主要货币实时汇率
- 支持美元(USD)、欧元(EUR)、日元(JPY)、港币(HKD)等
- 历史汇率查询

### 3. 节日提醒
- 中国传统节日（春节、中秋、端午等）
- 公历节日提醒
- 节日倒计时
- 节日习俗介绍

### 4. 生活小贴士
- 健康养生建议
- 饮食营养指导
- 生活小窍门
- 应急知识

### 5. 快速翻译
- 中英互译
- 支持短句和常用短语
- 发音指导（拼音）

## 使用方法

### 触发词
- "查询天气"、"今天天气怎么样"
- "汇率换算"、"人民币兑美元"
- "最近有什么节日"、"春节还有多久"
- "生活小贴士"、"健康建议"
- "翻译这句话"、"英文怎么说"

### 示例命令
```
天气 北京
汇率 USD CNY
节日 春节
小贴士 健康
翻译 "你好，世界"
```

## 技术实现

### 依赖
- 无外部API依赖（使用免费公共API）
- 纯JavaScript/Node.js实现

### 数据源
- 天气数据：中国气象局公开数据
- 汇率数据：中国人民银行公开数据
- 节日数据：本地数据库

## 安装与配置

1. 通过ClawdHub安装：
   ```bash
   clawdhub install chinese-daily-assistant
   ```

2. 无需额外配置，安装后即可使用

## 更新日志

### v1.0.0 (2026-02-27)
- 初始版本发布
- 包含5个核心功能
- 支持中国主要城市

## 贡献与支持

如有问题或建议，请在ClawdHub页面提交反馈。

## 许可证
MIT License