# 中文日常生活助手

![版本](https://img.shields.io/badge/版本-v1.0.0-blue)
![许可证](https://img.shields.io/badge/许可证-MIT-green)
![语言](https://img.shields.io/badge/语言-中文-red)

专为中文用户设计的日常生活助手技能包，提供天气查询、汇率换算、节日提醒、生活小贴士和快速翻译等实用功能。

## ✨ 功能特色

### 🌤️ 天气查询
- 支持中国主要城市（北京、上海、广州等）
- 实时天气信息（温度、湿度、空气质量）
- 简洁明了的数据展示

### 💱 汇率换算
- 人民币与主要货币实时汇率
- 支持双向换算（外币→人民币，人民币→外币）
- 包含美元、欧元、日元、港币等

### 🎉 节日提醒
- 中国传统节日信息
- 节日倒计时功能
- 节日习俗介绍

### 💡 生活小贴士
- 健康、饮食、运动等多类别建议
- 随机或按类别获取小贴士
- 实用生活知识

### 🔤 快速翻译
- 中英常用短语互译
- 支持问候语、日常用语等
- 简单易用的翻译功能

## 🚀 快速开始

### 安装
```bash
clawdhub install chinese-daily-assistant
```

### 使用方法
在Clawdbot中直接使用以下命令：

```
天气 北京
汇率 USD CNY 100
节日 春节
小贴士 健康
翻译 "你好"
```

## 📖 详细使用指南

### 1. 天气查询
```
天气 [城市名称]
```
示例：
```
天气 上海
天气 广州
```

### 2. 汇率换算
```
汇率 [源货币] [目标货币] [金额]
```
示例：
```
汇率 USD CNY 100    # 100美元兑人民币
汇率 CNY USD 720    # 720人民币兑美元
汇率               # 查看所有汇率
```

### 3. 节日查询
```
节日 [节日名称]
```
示例：
```
节日 春节
节日 中秋节
节日          # 查看所有节日
```

### 4. 生活小贴士
```
小贴士 [类别]
```
示例：
```
小贴士 健康
小贴士 饮食
小贴士        # 随机小贴士
```

### 5. 快速翻译
```
翻译 "文本内容"
```
示例：
```
翻译 "你好"
翻译 "Thank you"
```

## 🛠️ 技术细节

### 数据源
- 天气数据：模拟数据（实际应用可接入中国气象局API）
- 汇率数据：模拟数据（实际应用可接入中国人民银行API）
- 节日数据：本地数据库
- 翻译数据：常用短语词典

### 依赖
- Node.js环境
- 无外部API依赖（v1.0.0版本）

### 文件结构
```
chinese-daily-assistant/
├── SKILL.md          # 技能描述文件
├── package.json      # 项目配置
├── README.md         # 说明文档
└── scripts/
    ├── main.js       # 主程序
    └── test.js       # 测试脚本
```

## 🔄 更新计划

### v1.1.0 (计划中)
- [ ] 接入真实天气API
- [ ] 接入实时汇率API
- [ ] 增加更多城市支持
- [ ] 添加语音播报功能

### v1.2.0 (计划中)
- [ ] 增加日历集成
- [ ] 添加备忘录功能
- [ ] 支持个性化设置
- [ ] 多语言界面

## 🤝 贡献指南

欢迎提交Issue和Pull Request！

1. Fork本仓库
2. 创建功能分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 开启Pull Request

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 👥 作者

**浩乎助手** - *初始开发* - [ClawdHub](https://clawdhub.com)

## 🙏 致谢

- 感谢所有Clawdbot用户的支持
- 感谢开源社区的贡献
- 特别感谢Jenner提供开发机会

---

**提示**：本技能为v1.0.0基础版本，后续将持续更新和完善功能。