# 用户画像分类系统

## 用户维度分析框架

### 1. 旅行目的维度
#### 🎪 家庭出游型
- **核心需求**：儿童安全、家庭房型、亲子设施
- **预算特点**：中等偏高，愿意为便利付费
- **位置偏好**：景点附近、交通便利、安静环境
- **服务需求**：婴儿床、儿童餐、游乐设施、安全设施
- **决策因素**：家庭友好度、安全评价、儿童设施

#### 💼 商务出行型
- **核心需求**：商务设施、交通便利、发票服务
- **预算特点**：公司报销，关注性价比
- **位置偏好**：商务区、交通枢纽、会议中心附近
- **服务需求**：高速WiFi、会议室、打印服务、快速入住退房
- **决策因素**：商务设施、位置便利、品牌信任

#### 🎒 自由行游客型
- **核心需求**：性价比、特色体验、交通便利
- **预算特点**：价格敏感，追求价值
- **位置偏好**：景点附近、地铁口、美食街
- **服务需求**：旅游咨询、行李寄存、本地推荐
- **决策因素**：性价比、用户评价、特色体验

#### 🏝️ 度假休闲型
- **核心需求**：环境舒适、度假设施、特色体验
- **预算特点**：愿意为体验付费，预算灵活
- **位置偏好**：景区内、海景/山景、安静区域
- **服务需求**：SPA、泳池、餐厅、娱乐设施
- **决策因素**：环境质量、设施完善度、特色体验

#### 📚 学生背包客型
- **核心需求**：价格最低、社交氛围、基础设施
- **预算特点**：极致价格敏感
- **位置偏好**：交通枢纽、青年旅舍聚集区
- **服务需求**：储物柜、公共区域、厨房、社交活动
- **决策因素**：价格、社交氛围、基础卫生

### 2. 预算维度
#### 💰 经济型（<¥300/晚）
- **特点**：价格绝对优先
- **可接受妥协**：位置稍远、设施简单、房间较小
- **关注点**：基础卫生、安全、基本设施
- **适合平台**：美团、去哪儿、途牛民宿

#### 💵 舒适型（¥300-600/晚）
- **特点**：性价比平衡
- **要求**：基本舒适度、合理位置、基础服务
- **关注点**：用户评价、取消政策、交通便利
- **适合平台**：去哪儿、携程、美团

#### 💎 品质型（¥600-1000/晚）
- **特点**：品质优先
- **要求**：良好设施、优质服务、便利位置
- **关注点**：品牌信任、服务细节、设施完善
- **适合平台**：携程、飞猪、国际连锁官网

#### 🏰 奢华型（¥1000+/晚）
- **特点**：体验至上
- **要求**：顶级设施、个性化服务、独特体验
- **关注点**：品牌声誉、独家体验、管家服务
- **适合平台**：携程高端、酒店官网、定制服务

### 3. 出行方式维度
#### 🚇 公共交通依赖型
- **核心需求**：地铁/公交站附近
- **关注点**：步行距离、首末班车时间、换乘便利
- **位置权重**：地铁口（+30%）、公交站（+20%）
- **适合酒店**：地铁上盖、交通枢纽附近

#### 🚗 自驾出行型
- **核心需求**：免费停车场
- **关注点**：停车便利性、停车费用、车辆安全
- **位置权重**：免费停车（+40%）、宽敞车位（+20%）
- **适合酒店**：郊区酒店、度假村、有独立停车场

#### 🚕 打车出行型
- **核心需求**：打车便利
- **关注点**：打车等待时间、费用预估、夜间安全
- **位置权重**：主干道旁（+30%）、打车便利（+25%）
- **适合酒店**：市区主干道、地标建筑附近

#### 🚶 步行探索型
- **核心需求**：步行可达目的地
- **关注点**：步行距离、步行环境、安全指数
- **位置权重**：步行10分钟内（+50%）、步行环境（+20%）
- **适合酒店**：景区内、古镇内、步行街附近

### 4. 时间灵活性维度
#### ⏰ 时间严格型
- **特点**：行程固定，无法调整
- **需求**：确定有房、确定价格、确定政策
- **关注点**：房态保证、价格锁定、取消政策严格度
- **适合预订**：提前预订、不可取消特价房

#### 🔄 时间灵活型
- **特点**：行程可调整，追求最优价格
- **需求**：价格监控、灵活取消、最后一刻优惠
- **关注点**：价格趋势、取消灵活性、最后一刻优惠
- **适合预订**：限时优惠、最后一刻特价、免费取消

#### 📅 提前规划型
- **特点**：喜欢提前规划，避免临时慌乱
- **需求**：提前预订优惠、充足选择、充分比较
- **关注点**：提前预订折扣、房型选择、详细比较
- **适合预订**：提前7-30天预订、早鸟优惠

### 5. 服务偏好维度
#### 🛎️ 服务依赖型
- **特点**：重视酒店服务
- **需求**：24小时前台、行李服务、旅游咨询
- **关注点**：服务评分、员工态度、响应速度
- **适合酒店**：全服务酒店、国际连锁、高端民宿

#### 🏠 自助独立型
- **特点**：喜欢自助，减少打扰
- **需求**：自助入住、自助设施、隐私保护
- **关注点**：自助设施、隐私性、最小化打扰
- **适合酒店**：公寓式酒店、智能酒店、自助民宿

#### 🤝 社交互动型
- **特点**：喜欢与人交流
- **需求**：公共区域、社交活动、本地互动
- **关注点**：社交氛围、活动组织、本地体验
- **适合酒店**：青年旅舍、特色民宿、社交型酒店

### 6. 特殊需求维度
#### 👨‍👩‍👧‍👦 家庭特殊需求
- **儿童相关**：婴儿床、儿童餐椅、安全插座
- **老人相关**：无障碍设施、电梯、防滑
- **多人入住**：连通房、加床服务、多人早餐

#### 🩺 健康医疗需求
- **过敏需求**：无过敏原房间、特殊床品
- **医疗需求**：近医院、急救设备、医疗服务
- **特殊饮食**：特殊餐饮安排、厨房设施

#### ♿ 无障碍需求
- **移动障碍**：无障碍房间、电梯、坡道
- **视觉障碍**：盲文标识、语音提示
- **听觉障碍**：视觉提示、振动提醒

## 用户画像匹配算法

### 1. 画像识别流程
```
用户需求分析 → 维度评分 → 画像匹配 → 个性化推荐
```

### 2. 维度权重计算
每个维度根据用户需求自动计算权重：
- **旅行目的**：40%（最重要）
- **预算范围**：25%
- **出行方式**：15%
- **时间灵活性**：10%
- **服务偏好**：5%
- **特殊需求**：5%

### 3. 画像匹配规则
1. **精确匹配**：所有维度完全匹配
2. **主要匹配**：核心维度（目的+预算）匹配
3. **次要匹配**：部分维度匹配，需要调整推荐

### 4. 推荐调整策略
- **完全匹配**：直接使用该画像的推荐模板
- **部分匹配**：混合多个画像的推荐要素
- **不匹配**：使用通用推荐，标注可能的不匹配点

## 个性化推荐模板

### 家庭出游型推荐模板
```
🎯 **核心关注**：儿童安全 + 家庭便利
🏨 **酒店类型**：亲子酒店 > 家庭民宿 > 连锁酒店
📍 **位置要求**：景点步行距离 > 地铁口 > 安静区域
💰 **预算分配**：房间舒适度(40%) + 儿童设施(30%) + 位置(20%) + 服务(10%)
⚠️ **风险提示**：检查儿童安全设施、确认加床政策、验证家庭友好评价
```

### 商务出行型推荐模板
```
🎯 **核心关注**：商务效率 + 交通便利
🏨 **酒店类型**：商务酒店 > 国际连锁 > 会议酒店
📍 **位置要求**：商务区 > 交通枢纽 > 会议中心
💰 **预算分配**：位置便利(35%) + 商务设施(30%) + 服务效率(20%) + 品牌(15%)
⚠️ **风险提示**：确认发票政策、测试网络速度、验证商务设施
```

### 自由行游客型推荐模板
```
🎯 **核心关注**：性价比 + 特色体验
🏨 **酒店类型**：特色民宿 > 经济连锁 > 本地酒店
📍 **位置要求**：景点附近 > 美食街 > 地铁口
💰 **预算分配**：性价比(40%) + 位置(25%) + 特色(20%) + 评价(15%)
⚠️ **风险提示**：验证真实评价、检查交通便利、确认取消政策
```

## 多维度需求处理策略

### 1. 冲突需求处理
- **预算vs品质**：提供梯度选项（经济型→舒适型→品质型）
- **位置vs价格**：展示不同位置的同价位选择
- **便利vs特色**：平衡推荐，提供混合选择

### 2. 模糊需求澄清
- **预算不明确**：提供3个价格区间的选项
- **位置不具体**：推荐3个不同区域的选项
- **需求不清晰**：通过提问澄清，提供临时推荐

### 3. 复合需求满足
- **家庭+商务**：推荐家庭友好的商务酒店
- **度假+预算**：推荐性价比高的度假酒店
- **特色+便利**：推荐交通便利的特色民宿

## 用户画像数据库

### 记录格式
```yaml
用户ID: user_001
基础信息:
  旅行目的: 家庭出游
  预算范围: ¥400-600/晚
  出行方式: 自驾
  时间灵活性: 中等
  服务偏好: 服务依赖
  特殊需求: 儿童设施

历史行为:
  常去城市: [上海, 北京, 广州]
  偏好平台: 携程(60%), 去哪儿(30%), 美团(10%)
  平均提前预订: 14天
  取消频率: 低(5%)
  评价习惯: 详细评价+图片

推荐效果:
  接受率: 85%
  满意度: 4.5/5
  改进建议: 更多儿童设施细节
```

### 画像更新机制
1. **每次交互更新**：记录用户选择和反馈
2. **定期分析**：每月分析行为模式变化
3. **主动优化**：根据效果调整推荐策略
4. **用户确认**：重要变化主动向用户确认

## 实施指南

### 1. 用户需求收集模板
```
请告诉我您的：
1. 旅行目的：[家庭/商务/旅游/度假/其他]
2. 预算范围：[具体金额或区间]
3. 出行方式：[自驾/地铁/打车/步行]
4. 特殊需求：[儿童/老人/健康/其他]
5. 其他要求：[早餐/停车/WiFi/其他]
```

### 2. 画像匹配检查清单
- [ ] 旅行目的匹配度 ≥80%
- [ ] 预算范围完全覆盖
- [ ] 出行方式需求满足
- [ ] 特殊需求全部考虑
- [ ] 至少5个选项符合画像

### 3. 个性化推荐输出模板
```
根据您的[画像类型]需求，我们精选了以下选项：

**选项1：最适合[核心需求]**
[详细推荐理由匹配画像]

**选项2：最佳[次要需求]平衡**
[详细推荐理由匹配画像]

**选项3：最高性价比选择**
[详细推荐理由匹配画像]

**选项4：特色体验推荐**
[详细推荐理由匹配画像]

**选项5：备选安全选择**
[详细推荐理由匹配画像]

**个性化建议**：
基于您的画像，我们特别建议关注：[具体建议]
```

## 效果评估指标

### 1. 匹配准确度
- 画像识别准确率
- 需求覆盖完整度
- 推荐接受率

### 2. 用户满意度
- 预订转化率
- 用户评价分数
- 重复使用率

### 3. 系统优化
- 画像更新及时性
- 推荐算法改进
- 用户反馈响应

---

通过这个多维度用户画像系统，skill可以更精准地理解和服务不同用户的需求，提供真正个性化的酒店推荐服务。