# 用户偏好记录模板

## 用户基本信息
```
用户ID：[自动生成或用户标识]
记录时间：YYYY-MM-DD HH:MM
上次更新时间：YYYY-MM-DD HH:MM
```

## 旅行偏好

### 1. 出行类型偏好
- [ ] **商务出行**
  - 优先考虑：位置便利、商务设施、发票服务
  - 预算范围：中等偏高
  - 品牌偏好：国际连锁、高端商务酒店
  - 特殊需求：会议室、打印服务、快速入住退房

- [ ] **旅游度假**
  - 优先考虑：景点距离、休闲设施、景观
  - 预算范围：灵活，根据目的地调整
  - 品牌偏好：度假酒店、特色民宿
  - 特殊需求：游泳池、餐厅、旅游咨询

- [ ] **家庭出游**
  - 优先考虑：家庭房型、儿童设施、安全
  - 预算范围：中等
  - 品牌偏好：家庭友好型酒店
  - 特殊需求：儿童床、游乐场、婴儿服务

- [ ] **背包客/经济型**
  - 优先考虑：价格、交通便利、社交氛围
  - 预算范围：低
  - 品牌偏好：青旅、经济型连锁
  - 特殊需求：储物柜、公共区域、厨房

### 2. 酒店类型偏好
- **星级要求**：
  - [ ] 经济型（1-2星）
  - [ ] 舒适型（3星）
  - [ ] 高档型（4星）
  - [ ] 豪华型（5星）
  - [ ] 无要求

- **品牌偏好**：
  - 国际连锁：万豪、希尔顿、洲际等
  - 国内连锁：华住、锦江、首旅如家等
  - 本土品牌：地方特色酒店
  - 民宿/公寓： Airbnb风格

- **位置偏好**：
  - 市中心/商务区
  - 景区附近
  - 交通枢纽旁
  - 安静居民区
  - 特定地标附近

### 3. 设施服务偏好
- **必选设施**：
  - [ ] 免费WiFi
  - [ ] 空调/暖气
  - [ ] 独立卫生间
  - [ ] 24小时热水
  - [ ] 电梯

- **重要设施**：
  - [ ] 免费早餐
  - [ ] 停车场
  - [ ] 健身房
  - [ ] 游泳池
  - [ ] 商务中心

- **增值服务**：
  - [ ] 机场接送
  - [ ] 行李寄存
  - [ ] 旅游咨询
  - [ ] 洗衣服务
  - [ ] 叫车服务

### 4. 价格敏感度
- **预算范围**：
  - 经济型：¥200-400/晚
  - 舒适型：¥400-800/晚
  - 高档型：¥800-1500/晚
  - 豪华型：¥1500+/晚

- **价格策略**：
  - [ ] 价格优先（选择最低价）
  - [ ] 性价比优先（平衡价格和服务）
  - [ ] 服务优先（选择最好服务）
  - [ ] 品牌优先（选择信任品牌）

- **优惠偏好**：
  - [ ] 喜欢使用优惠券
  - [ ] 关注会员权益
  - [ ] 偏好套餐优惠
  - [ ] 关注限时特价

## 历史行为记录

### 1. 搜索历史
```
日期：YYYY-MM-DD
目的地：[城市]
入住日期：[日期]
离店日期：[日期]
搜索条件：[详细条件]
查看酒店：[酒店列表]
最终选择：[酒店+平台]
选择理由：[理由]
实际体验：[评分/评价]
```

### 2. 预订偏好
- **预订渠道**：
  - 最常使用平台：[平台名称]
  - 备用平台：[平台名称]
  - 直接预订倾向：[是/否]

- **预订时间**：
  - 平均提前预订天数：[数字]
  - 偏好预订时段：[工作日/周末/节假日]
  - 最后一刻预订频率：[高/中/低]

- **支付方式**：
  - 首选支付：[微信/支付宝/银行卡]
  - 分期付款倾向：[是/否]
  - 押金支付偏好：[信用卡/现金/免押]

### 3. 取消和变更
- **取消频率**：[高/中/低]
- **变更频率**：[高/中/低]
- **偏好取消政策**：
  - [ ] 免费取消
  - [ ] 限时取消
  - [ ] 不可取消但价格优惠
- **变更处理经验**：[正面/负面]

## 评价和反馈模式

### 1. 评价关注点
- **最重要因素**：
  1. [ ] 卫生清洁
  2. [ ] 服务态度
  3. [ ] 位置便利
  4. [ ] 设施设备
  5. [ ] 性价比

- **评价习惯**：
  - [ ] 经常写详细评价
  - [ ] 只写简短评价
  - [ ] 很少写评价
  - [ ] 只评分不写文字

### 2. 投诉模式
- **常见投诉原因**：
  - [ ] 卫生问题
  - [ ] 服务问题
  - [ ] 设施问题
  - [ ] 噪音问题
  - [ ] 价格问题

- **投诉处理期望**：
  - [ ] 快速响应
  - [ ] 合理补偿
  - [ ] 问题解决
  - [ ] 改进承诺

## 特殊需求和限制

### 1. 身体需求
- **无障碍需求**：
  - [ ] 需要无障碍房间
  - [ ] 需要电梯
  - [ ] 需要坡道
  - [ ] 其他：[具体需求]

- **健康需求**：
  - [ ] 无烟房间
  - [ ] 低过敏房间
  - [ ] 特殊床垫
  - [ ] 医疗设施附近

### 2. 饮食需求
- **餐饮限制**：
  - [ ] 素食
  - [ ] 清真
  - [ ] 无麸质
  - [ ] 其他过敏源

- **早餐偏好**：
  - [ ] 中式早餐
  - [ ] 西式早餐
  - [ ] 自助早餐
  - [ ] 不需要早餐

### 3. 工作需求
- **商务设施**：
  - [ ] 稳定高速WiFi
  - [ ] 办公桌和椅子
  - [ ] 多个电源插座
  - [ ] 打印机/复印机

- **会议需求**：
  - [ ] 小型会议室
  - [ ] 视频会议设备
  - [ ] 白板/投影仪
  - [ ] 茶歇服务

## 平台使用偏好

### 1. 平台信任度
| 平台 | 使用频率 | 信任度 | 偏好原因 | 避免原因 |
|------|----------|--------|----------|----------|
| 携程 | 高/中/低 | 高/中/低 | [原因] | [原因] |
| 去哪儿 | 高/中/低 | 高/中/低 | [原因] | [原因] |
| 美团 | 高/中/低 | 高/中/低 | [原因] | [原因] |
| 飞猪 | 高/中/低 | 高/中/低 | [原因] | [原因] |
| 途牛 | 高/中/低 | 高/中/低 | [原因] | [原因] |

### 2. 平台功能偏好
- **搜索功能**：偏好哪个平台的搜索体验
- **比价功能**：是否经常使用比价功能
- **预订流程**：哪个平台预订最顺畅
- **客服体验**：哪个平台客服最满意
- **售后服务**：哪个平台售后处理最好

### 3. 会员权益利用
- **会员等级**：各平台当前会员等级
- **权益使用**：经常使用哪些会员权益
- **积分习惯**：是否关注和积累积分
- **升级目标**：是否有会员升级计划

## 沟通和推荐偏好

### 1. 信息呈现方式
- **详细程度**：
  - [ ] 需要非常详细的信息
  - [ ] 需要关键信息摘要
  - [ ] 只需要最终推荐

- **比较方式**：
  - [ ] 喜欢表格对比
  - [ ] 喜欢文字描述
  - [ ] 喜欢图表展示
  - [ ] 喜欢链接参考

- **选项数量偏好**：
  - [ ] 希望看到5个以上选项（默认）
  - [ ] 希望看到3-5个精选选项
  - [ ] 希望看到更多选项（7-10个）
  - [ ] 只需要1-2个最佳推荐

- **决策支持**：
  - [ ] 需要多个选项对比（不少于5个）
  - [ ] 需要明确推荐一个（从多个选项中）
  - [ ] 需要利弊分析
  - [ ] 需要风险提示

### 2. 沟通频率
- **更新频率**：
  - [ ] 需要实时更新
  - [ ] 每天更新一次
  - [ ] 有重要变化时更新
  - [ ] 最终确认时更新

- **提醒偏好**：
  - [ ] 价格变化提醒
  - [ ] 房态变化提醒
  - [ ] 优惠活动提醒
  - [ ] 预订截止提醒

### 3. 后续服务期望
- **预订后服务**：
  - [ ] 预订确认提醒
  - [ ] 入住前提醒
  - [ ] 当地信息提供
  - [ ] 应急联系方式

- **体验反馈**：
  - [ ] 入住后体验询问
  - [ ] 问题协助解决
  - [ ] 评价撰写协助
  - [ ] 下次旅行建议

## 偏好更新记录

### 更新日志
```
更新日期：YYYY-MM-DD
更新内容：[具体更新]
更新原因：[原因]
影响范围：[影响的偏好类别]
```

### 趋势分析
- **偏好变化趋势**：[描述变化趋势]
- **稳定性评估**：[偏好是否稳定]
- **预测调整**：[预计未来可能的变化]

## 使用指南

### 数据收集方法
1. **直接询问**：在服务过程中询问偏好
2. **行为观察**：通过历史记录分析偏好
3. **反馈收集**：通过评价和反馈了解偏好
4. **主动确认**：重要偏好主动确认

### 数据应用原则
1. **个性化推荐**：基于偏好提供个性化选择
2. **效率优化**：减少不相关选项的展示
3. **体验提升**：提供符合偏好的服务体验
4. **信任建立**：通过理解偏好建立信任

### 隐私保护
1. **数据安全**：确保用户数据安全存储
2. **使用授权**：明确告知数据使用方式
3. **控制权**：用户可查看和修改自己的偏好
4. **删除权**：用户可要求删除偏好数据

---

**记录建议**：
- 每次服务后更新相关偏好
- 定期（每季度）回顾和整理
- 注意偏好可能随时间变化
- 尊重用户隐私和数据安全