# 搜索策略指南

## 核心原则：不少于5个选项
**每次搜索必须确保最终提供不少于5个精选酒店选项**

### 搜索数量要求：
1. **初步筛选**：每个平台至少搜索5-8个符合条件的酒店
2. **候选池**：总共收集20-30个候选酒店
3. **最终精选**：从候选池中精选不少于5个最佳选项
4. **多样性保证**：确保5个选项覆盖不同价格、类型、平台、特色

## 各平台搜索特点

### 携程搜索技巧
1. **高级筛选**：
   - 使用"地图找房"功能精确定位
   - 筛选"免费取消"和"到店付"
   - 选择"携程优选"标识酒店

2. **价格优化**：
   - 关注"今夜特价"和"明日特价"
   - 查看"连住优惠"（2晚以上）
   - 使用"企业协议价"（如有）

3. **会员权益**：
   - 钻石会员：免费早餐、房型升级
   - 金牌会员：延迟退房、欢迎水果

### 去哪儿搜索技巧
1. **比价功能**：
   - 使用"价格排序"从低到高
   - 查看"历史价格"曲线
   - 关注"全网比价"结果

2. **优惠获取**：
   - 新用户专享优惠
   - 学生认证优惠
   - 节假日促销券

3. **评价系统**：
   - 查看"真实住客点评"
   - 关注"带图评价"
   - 注意"追评"内容

### 美团搜索技巧
1. **本地化搜索**：
   - 使用"附近酒店"功能
   - 筛选"美团专享"价格
   - 查看"本地人推荐"

2. **套餐优惠**：
   - "酒店+餐饮"套餐
   - "酒店+景点"套餐
   - "酒店+SPA"套餐

3. **支付优惠**：
   - 美团支付立减
   - 优惠券叠加
   - 会员折扣

### 飞猪搜索技巧
1. **阿里生态**：
   - 支付宝会员等级匹配
   - 芝麻信用免押金
   - 花呗分期支付

2. **旅行套餐**：
   - "机票+酒店"组合
   - "火车票+酒店"组合
   - "景点门票+酒店"组合

3. **会员特权**：
   - F1-F4会员权益
   - 信用住专属价格
   - 快速入住通道

### 途牛搜索技巧
1. **度假特色**：
   - "跟团游+酒店"套餐
   - "自由行+酒店"套餐
   - "定制游+酒店"套餐

2. **目的地专精**：
   - 热门旅游城市覆盖全
   - 度假酒店资源丰富
   - 当地导游服务整合

3. **服务保障**：
   - 24小时客服
   - 行程变更协助
   - 应急处理支持

## 搜索流程模板

### 基础搜索流程（确保不少于5个选项）
```
1. 确定核心需求（城市、日期、预算）
2. 携程初步搜索 - 筛选5个不同价位酒店
3. 去哪儿价格对比 - 筛选5个性价比最高酒店
4. 美团本地优惠 - 筛选5个有优惠活动酒店
5. 飞猪会员权益 - 筛选5个会员权益最优酒店
6. 途牛套餐选择 - 筛选5个特色套餐酒店
7. 建立候选池（共25个酒店）
8. 综合比较和精选不少于5个最佳选项
9. 按价格、类型、平台、特色分类展示
```

### 高级搜索流程（深度比价+不少于5个选项）
```
1. 多平台并行搜索（每个平台5-8个候选）
2. 建立候选池（总计20-30个酒店）
3. 价格数据标准化（统一计算总成本）
4. 服务价值评估（评分、设施、服务）
5. 风险因素分析（取消政策、评价真实性）
6. 个性化匹配（根据用户需求筛选）
7. 精选不少于5个最佳选项
8. 分类展示（按价格区间、酒店类型、平台优势）
9. 提供详细比较和推荐理由
```

## 搜索参数优化

### 时间参数
- **入住时间**：15:00后（标准入住）
- **离店时间**：12:00前（标准退房）
- **提前预订**：旺季30天，淡季7天
- **最后一刻**：当日18:00后特价

### 位置参数
- **市中心**：商务区、商业区
- **交通枢纽**：机场、火车站、地铁站
- **景区周边**：景点、公园、地标
- **生活区**：居民区、学校、医院

### 设施参数
- **必选设施**：WiFi、空调、热水
- **商务设施**：办公桌、会议室、打印
- **家庭设施**：儿童床、游乐场、泳池
- **无障碍**：电梯、坡道、无障碍房间

## 数据采集标准

### 价格数据
1. **基础价格**：房费/晚
2. **附加费用**：服务费、税费、清洁费
3. **优惠抵扣**：优惠券、会员折扣、活动
4. **最终价格**：实际支付金额

### 服务数据
1. **基础服务**：早餐、WiFi、停车
2. **增值服务**：接送、洗衣、导游
3. **限制条件**：取消政策、入住要求
4. **保障服务**：客服、保险、救援

### 评价数据
1. **评分分布**：总体评分、各维度评分
2. **评价内容**：最新评价、详细评价
3. **问题反馈**：常见投诉、解决方案
4. **改进情况**：酒店响应和改进

## 搜索效率技巧

### 批量搜索
1. **多标签浏览**：同时打开多个平台
2. **数据抓取**：使用工具提取关键信息
3. **对比表格**：实时更新价格数据

### 自动化辅助
1. **价格监控**：设置价格提醒
2. **历史对比**：查看价格趋势
3. **智能推荐**：基于历史偏好推荐

### 人工验证
1. **电话确认**：重要订单电话确认
2. **位置验证**：地图实景验证
3. **评价核实**：多渠道验证评价真实性

## 特殊情况处理

### 价格异常
1. **过低价格**：核实房态和限制条件
2. **价格波动**：分析波动原因和规律
3. **显示错误**：清除缓存重新搜索

### 房态异常
1. **显示有房实际无房**：立即联系客服
2. **房型不符**：截图保存证据
3. **价格不一致**：保留报价页面

### 平台异常
1. **网站故障**：等待恢复或使用APP
2. **支付问题**：更换支付方式或平台
3. **客服无响应**：升级投诉渠道

## 搜索记录模板

### 搜索日志格式
```
搜索时间：YYYY-MM-DD HH:MM
搜索条件：城市-日期-人数-预算
平台1（携程）：[价格]-[房型]-[政策]
平台2（去哪儿）：[价格]-[房型]-[政策]
平台3（美团）：[价格]-[房型]-[政策]
最优选择：[平台]-[理由]
备注：[特殊发现或问题]
```

### 价格趋势记录
```
酒店名称：[名称]
监控周期：[开始日期]-[结束日期]
价格波动：[最低价]-[最高价]-[平均价]
最佳预订时机：[日期]-[价格]
建议：[预订建议]
```

## 质量检查清单

### 搜索前检查
- [ ] 需求明确（城市、日期、人数、预算）
- [ ] 平台选择合理（根据需求类型）
- [ ] 搜索条件准确（避免歧义）

### 搜索中检查
- [ ] 价格数据完整（含所有费用）
- [ ] 房态信息准确（实时验证）
- [ ] 政策条款清晰（取消、变更）

### 搜索后检查
- [ ] 结果数量达标（不少于5个精选选项）
- [ ] 结果对比全面（覆盖3个以上平台）
- [ ] 选项多样性（不同价格、类型、特色）
- [ ] 推荐理由充分（匹配用户需求）
- [ ] 风险提示到位（潜在问题）
- [ ] 分类清晰（按价格、类型、平台分类）

---

**使用提示**：根据具体搜索需求选择合适的策略组合，平衡搜索效率和结果质量。