# 价格计算指南

## 总成本计算模型

### 基础计算公式
```
总成本 = (房费 × 晚数) + 平台服务费 + 税费 + 其他附加费 - 优惠抵扣
```

### 详细费用分解

#### 1. 房费构成
- **基础房费**：平台显示的单晚价格
- **差异化定价**：
  - 工作日 vs 周末价格
  - 旺季 vs 淡季价格
  - 提前预订 vs 最后一刻价格

#### 2. 平台服务费
- **携程**：通常0-10%，高端酒店较高
- **去哪儿**：通常5-15%，价格越低比例越高
- **美团**：通常0-8%，本地酒店较低
- **飞猪**：通常5-12%，套餐可能包含
- **途牛**：通常10-20%，含服务费

#### 3. 政府税费
- **增值税**：6%（一般纳税人）
- **城市维护建设税**：7%（按增值税）
- **教育费附加**：3%（按增值税）
- **地方教育附加**：2%（按增值税）
- **旅游税/城市建设费**：各地不同，通常¥5-50/晚

#### 4. 其他附加费
- **清洁费**：民宿常见，¥50-200/次
- **加床费**：¥100-300/晚
- **停车费**：¥20-100/天
- **早餐费**：¥30-150/人/天
- **网络费**：部分酒店单独收费
- **度假村费**：度假酒店常见

#### 5. 优惠抵扣
- **平台优惠券**：满减券、折扣券
- **会员折扣**：平台会员等级折扣
- **活动优惠**：节假日促销、闪购
- **积分抵扣**：平台积分兑换
- **银行卡优惠**：银行合作活动

## 各平台价格计算示例

### 携程价格计算
```
示例：豪华大床房 ¥588/晚，住3晚
1. 基础房费：¥588 × 3 = ¥1,764
2. 服务费：¥1,764 × 8% = ¥141.12
3. 税费：¥1,764 × 6% = ¥105.84
4. 旅游税：¥10 × 3 = ¥30
5. 优惠：钻石会员95折：¥1,764 × 5% = ¥88.2
总成本：¥1,764 + ¥141.12 + ¥105.84 + ¥30 - ¥88.2 = ¥1,952.76
```

### 去哪儿价格计算
```
示例：同酒店同房型 ¥568/晚
1. 基础房费：¥568 × 3 = ¥1,704
2. 服务费：¥1,704 × 12% = ¥204.48
3. 税费：¥1,704 × 6% = ¥102.24
4. 旅游税：¥10 × 3 = ¥30
5. 优惠：新用户券¥50
总成本：¥1,704 + ¥204.48 + ¥102.24 + ¥30 - ¥50 = ¥1,990.72
```

### 美团价格计算
```
示例：同酒店同房型 ¥598/晚
1. 基础房费：¥598 × 3 = ¥1,794
2. 服务费：¥1,794 × 5% = ¥89.7
3. 税费：¥1,794 × 6% = ¥107.64
4. 旅游税：¥10 × 3 = ¥30
5. 优惠：美团支付立减¥30
总成本：¥1,794 + ¥89.7 + ¥107.64 + ¥30 - ¥30 = ¥1,991.34
```

## 价格比较模板

### 比价表格
| 费用项目 | 携程 | 去哪儿 | 美团 | 飞猪 | 途牛 |
|----------|------|--------|------|------|------|
| 房费/晚 | ¥588 | ¥568 | ¥598 | ¥578 | ¥608 |
| 住3晚房费 | ¥1,764 | ¥1,704 | ¥1,794 | ¥1,734 | ¥1,824 |
| 服务费比例 | 8% | 12% | 5% | 10% | 15% |
| 服务费金额 | ¥141.12 | ¥204.48 | ¥89.7 | ¥173.4 | ¥273.6 |
| 税费(6%) | ¥105.84 | ¥102.24 | ¥107.64 | ¥104.04 | ¥109.44 |
| 旅游税(¥10/晚) | ¥30 | ¥30 | ¥30 | ¥30 | ¥30 |
| 小计 | ¥2,040.96 | ¥2,040.72 | ¥2,021.34 | ¥2,041.44 | ¥2,237.04 |
| 优惠抵扣 | ¥88.2 | ¥50 | ¥30 | ¥60 | ¥100 |
| **最终总价** | **¥1,952.76** | **¥1,990.72** | **¥1,991.34** | **¥1,981.44** | **¥2,137.04** |
| **实际每晚** | **¥650.92** | **¥663.57** | **¥663.78** | **¥660.48** | **¥712.35** |

### 价格分析要点
1. **表面价格 vs 实际价格**：去哪儿表面价格最低，但服务费高
2. **优惠有效性**：携程会员折扣最大，但需要高等级会员
3. **总成本对比**：飞猪实际价格最优，平衡了价格和服务费
4. **价值评估**：途牛价格最高但包含更多服务

## 特殊场景价格计算

### 节假日价格
```
基础公式：节假日价格 = 平日价格 × 旺季系数
旺季系数参考：
- 春节/国庆：2.0-3.0倍
- 五一/端午：1.5-2.0倍
- 周末/小长假：1.2-1.5倍
```

### 长期住宿价格
```
月租价格计算：
1. 按日计算总价
2. 申请长期住宿折扣（通常8-9折）
3. 考虑水电网络费用
4. 计算押金和付款方式
```

### 套餐价格
```
机票+酒店套餐：
1. 分别计算机票和酒店单独价格
2. 计算套餐总价
3. 比较套餐节省金额
4. 评估套餐限制条件
```

## 价格监控策略

### 价格波动规律
1. **提前预订优惠**：提前30天预订最优惠
2. **最后一刻特价**：入住前24小时内可能降价
3. **工作日价格**：周二-周四价格较低
4. **周末价格**：周五-周日价格较高

### 价格提醒设置
1. **目标价格**：设定心理价位
2. **降价提醒**：价格下降10%以上
3. **库存提醒**：房量少于3间时提醒
4. **活动提醒**：平台促销活动开始

### 历史价格分析
1. **价格趋势图**：绘制30天价格曲线
2. **最低价记录**：记录历史最低价格
3. **最佳预订时间**：分析价格最低的时间点
4. **价格预测**：基于历史数据预测未来价格

## 费用透明度检查

### 隐藏费用识别
- [ ] 服务费是否明确标注
- [ ] 税费是否包含在总价中
- [ ] 旅游税是否单独列出
- [ ] 清洁费是否提前告知
- [ ] 押金金额和退还条件

### 价格对比验证
1. **平台间对比**：同一酒店不同平台价格
2. **直接预订对比**：酒店官网 vs 平台价格
3. **历史价格对比**：当前价格 vs 历史价格
4. **同类酒店对比**：同星级同区域价格

### 价格合理性评估
1. **市场均价参考**：同星级酒店市场平均价格
2. **地理位置溢价**：市中心 vs 郊区价格差异
3. **时间因素影响**：旺季 vs 淡季价格差异
4. **服务价值匹配**：价格 vs 提供的服务

## 计算工具和模板

### 快速计算模板
```markdown
**酒店名称**：[名称]
**入住日期**：[日期]
**离店日期**：[日期]
**晚数**：[数字]

| 平台 | 房费/晚 | 服务费% | 税费 | 其他费用 | 优惠 | 总价 |
|------|---------|---------|------|----------|------|------|
| 平台1 | ¥XXX | X% | ¥XX | ¥XX | -¥XX | ¥XXX |
| 平台2 | ¥XXX | X% | ¥XX | ¥XX | -¥XX | ¥XXX |
| 平台3 | ¥XXX | X% | ¥XX | ¥XX | -¥XX | ¥XXX |

**推荐平台**：[平台名称]
**推荐理由**：[具体理由]
```

### 自动化计算脚本
```bash
# 价格计算脚本示例
#!/bin/bash
# 输入：房费、晚数、服务费率、优惠金额
# 输出：总成本

ROOM_RATE=$1
NIGHTS=$2
SERVICE_FEE_RATE=$3
DISCOUNT=$4

# 计算基础房费
BASE_FARE=$(echo "$ROOM_RATE * $NIGHTS" | bc)

# 计算服务费
SERVICE_FEE=$(echo "$BASE_FARE * $SERVICE_FEE_RATE / 100" | bc)

# 计算税费（假设6%）
TAX=$(echo "$BASE_FARE * 0.06" | bc)

# 计算旅游税（假设¥10/晚）
TOURISM_TAX=$(echo "10 * $NIGHTS" | bc)

# 计算总成本
TOTAL=$(echo "$BASE_FARE + $SERVICE_FEE + $TAX + $TOURISM_TAX - $DISCOUNT" | bc)

echo "总成本：¥$TOTAL"
```

## 注意事项

### 计算准确性
1. **实时数据**：使用最新价格数据
2. **汇率考虑**：国际酒店考虑汇率波动
3. **政策变化**：关注税费政策变化

### 用户沟通
1. **费用透明**：清晰展示所有费用
2. **价格解释**：解释价格构成和差异
3. **选择建议**：基于计算结果的建议

### 风险提示
1. **价格变动**：提醒价格可能变动
2. **优惠限制**：说明优惠使用条件
3. **退款政策**：明确退款计算方式

---

**重要提示**：所有价格计算应以实时查询结果为准，模板数据仅供参考。