# 个性化推荐引擎

## 推荐算法框架

### 1. 多维度评分系统

#### 基础评分维度（每项0-10分）
```
1. 价格匹配度 (权重: 25%)
   - 绝对价格分：预算范围内=10分，超预算按比例扣分
   - 性价比分：同类型酒店中价格竞争力
   - 优惠价值分：优惠券、会员权益价值

2. 位置便利度 (权重: 20%)
   - 核心距离分：到主要目的地的距离
   - 交通便利分：公共交通可达性
   - 周边配套分：餐饮、购物、娱乐配套

3. 设施服务分 (权重: 15%)
   - 基础设施分：WiFi、空调、卫生等
   - 特色设施分：泳池、健身房、SPA等
   - 服务质量分：前台、清洁、餐饮服务

4. 用户评价分 (权重: 15%)
   - 总体评分：平台评分转换
   - 评价真实性：带图评价比例、最新评价
   - 问题模式：常见投诉问题分析

5. 取消灵活性 (权重: 10%)
   - 取消政策分：免费取消=10分，不可取消=0分
   - 变更便利分：日期/房型变更便利性
   - 退款速度分：退款处理速度

6. 品牌信任度 (权重: 8%)
   - 品牌知名度：国际连锁、国内知名、本地品牌
   - 平台信任度：用户对平台的信任程度
   - 历史表现：该品牌/平台的稳定表现

7. 特色体验分 (权重: 7%)
   - 独特性：特色建筑、主题房间、文化体验
   - 本地化：本地特色、民俗体验
   - 社交价值：社交活动、文化交流
```

#### 用户画像权重调整
根据用户画像动态调整权重：
- **家庭出游型**：位置便利度(+5%)、设施服务分(+5%)、价格匹配度(-10%)
- **商务出行型**：品牌信任度(+10%)、设施服务分(+5%)、特色体验分(-15%)
- **自由行游客型**：价格匹配度(+10%)、特色体验分(+5%)、品牌信任度(-15%)
- **度假休闲型**：特色体验分(+15%)、设施服务分(+5%)、位置便利度(-20%)

### 2. 推荐排序算法

#### 综合得分计算
```
综合得分 = Σ(维度分 × 调整后权重)
```

#### 排序规则
1. **主排序**：综合得分降序
2. **次排序**：相同得分时按价格升序
3. **最终排序**：确保多样性（不同类型、价格区间）

#### 多样性保证算法
```
function ensureDiversity(options, minCount=5) {
  1. 按综合得分排序所有候选
  2. 选择top 10作为候选池
  3. 按以下规则选择最终5+个选项：
     - 必须包含：最低价选项、最高性价比选项
     - 必须覆盖：至少3个不同平台
     - 必须包含：至少2种酒店类型
     - 必须包含：至少2个价格区间
  4. 如果多样性不足，从候选池补充
  5. 重新排序展示
}
```

### 3. 个性化过滤规则

#### 基于旅行目的的过滤
```yaml
家庭出游:
  必须包含: 家庭房型、儿童设施、安全评价良好
  优先考虑: 亲子主题、游乐设施、家庭套餐
  排除: 仅限成人、不接待儿童、噪音大

商务出行:
  必须包含: 商务设施、高速WiFi、发票服务
  优先考虑: 行政楼层、会议室、快速通道
  排除: 无商务设施、网络不稳定

自由行游客:
  必须包含: 交通便利、性价比高、评价真实
  优先考虑: 特色体验、本地推荐、灵活取消
  排除: 位置偏远、价格虚高、评价造假

度假休闲:
  必须包含: 环境优美、休闲设施、服务优质
  优先考虑: 景观房、度假套餐、特色活动
  排除: 商务氛围浓、设施简陋、服务差
```

#### 基于预算的过滤
```yaml
经济型(<¥300):
  重点关注: 基础卫生、安全、基本设施
  可接受: 位置稍远、房间较小、设施简单
  排除: 卫生差评、安全隐患、虚假宣传

舒适型(¥300-600):
  重点关注: 性价比、用户评价、交通便利
  要求: 基本舒适度、合理服务、真实评价
  排除: 性价比低、评价虚假、服务差

品质型(¥600-1000):
  重点关注: 品牌信任、服务细节、设施完善
  要求: 良好品质、优质服务、便利位置
  排除: 品质不符、服务不到位、位置不便

奢华型(¥1000+):
  重点关注: 独特体验、顶级服务、品牌声誉
  要求: 卓越体验、个性化服务、环境优越
  排除: 价格虚高、服务不匹配、体验普通
```

### 4. 智能推荐策略

#### 策略1：梯度推荐法
```
为用户提供从"最经济"到"最舒适"的梯度选择：
1. 极致经济型：价格最低，满足基本需求
2. 高性价比型：价格适中，性价比最高
3. 平衡选择型：价格服务平衡，风险最低
4. 品质体验型：品质较好，体验更佳
5. 特色推荐型：独特体验，值得尝试
```

#### 策略2：风险平衡法
```
根据用户风险承受能力调整推荐：
低风险偏好：
  优先：免费取消、高评分、连锁品牌
  避免：不可取消、新开业、评价少

中风险偏好：
  平衡：性价比、评价真实性、取消政策
  可尝试：特色民宿、新酒店、限时优惠

高风险偏好：
  追求：极致价格、独特体验、高回报
  接受：不可取消、评价较少、位置一般
```

#### 策略3：学习优化法
```
基于用户历史行为优化推荐：
1. 记录用户每次的选择和反馈
2. 分析偏好模式：常选平台、价格区间、酒店类型
3. 调整推荐权重：增加偏好维度权重
4. 提供相似推荐：基于成功案例推荐类似选择
```

### 5. 推荐输出模板

#### 标准输出结构
```
🎯 **基于您的[用户画像]个性化推荐**

📊 **推荐策略说明**：
[解释为什么这些选项适合您的需求]

🏆 **综合排名前5+选项**：

**第1名：[酒店名称] - [核心优势]**
- 综合得分：8.5/10
- 价格：¥XXX/晚（总¥XXX）
- 适合：[具体适合原因]
- 亮点：[独特优势]
- 注意：[重要提醒]

**第2名：[酒店名称] - [核心优势]**
[同样格式...]

**第3-5名**：[简要说明其他选项特点]

📈 **各维度对比分析**：
| 选项 | 价格分 | 位置分 | 设施分 | 评价分 | 综合分 |
|------|--------|--------|--------|--------|--------|
| 选项1 | 9.0 | 8.5 | 8.0 | 8.5 | 8.5 |
| 选项2 | 8.5 | 9.0 | 7.5 | 8.0 | 8.3 |
| ... | ... | ... | ... | ... | ... |

💡 **个性化建议**：
1. 如果您重视[维度A]，建议选择[选项X]
2. 如果您关注[维度B]，建议考虑[选项Y]
3. 如果预算允许，[选项Z]值得体验

⚠️ **风险提示**：
[基于您画像的特定风险提醒]
```

#### 快速比较视图
```
🏨 **快速比较**：
1. 💰 最省钱：选项A（¥288/晚）- 适合极致预算
2. ⭐ 最高分：选项B（4.8分）- 适合重视评价
3. 🚇 最便利：选项C（地铁口）- 适合公共交通
4. 🏊 最特色：选项D（无边泳池）- 适合度假体验
5. 🛌 最舒适：选项E（品牌保障）- 适合品质要求
```

### 6. 用户反馈收集

#### 反馈收集模板
```
请帮助我们改进推荐：
1. 这些选项符合您的需求吗？[是/部分/否]
2. 您最关注哪个维度？[价格/位置/设施/评价/其他]
3. 您可能会选择哪个选项？为什么？
4. 有什么我们遗漏的重要需求吗？
```

#### 反馈分析规则
```yaml
反馈类型: 选项不符合需求
分析动作:
  - 检查用户画像匹配度
  - 分析遗漏的需求维度
  - 调整推荐算法参数
  - 提供补充选项

反馈类型: 信息不完整
分析动作:
  - 补充缺失信息
  - 优化信息呈现方式
  - 提供更多细节选项
  - 改进沟通 clarity

反馈类型: 推荐成功
分析动作:
  - 记录成功模式
  - 强化相关推荐策略
  - 更新用户画像偏好
  - 建立推荐模板
```

### 7. 持续优化机制

#### A/B测试框架
```
测试组A: 使用当前推荐算法
测试组B: 使用优化后算法

对比指标:
  - 推荐接受率
  - 用户满意度评分
  - 预订转化率
  - 用户反馈质量
```

#### 算法迭代流程
```
1. 收集用户反馈和数据
2. 分析推荐效果指标
3. 识别改进机会点
4. 设计优化方案
5. A/B测试验证
6. 全量推广优化
7. 持续监控效果
```

#### 性能监控指标
```yaml
实时监控:
  - 推荐响应时间: <3秒
  - 选项数量: 5-8个
  - 多样性达标率: >90%
  - 用户画像匹配度: >80%

定期分析:
  - 每周: 推荐成功率分析
  - 每月: 算法效果评估
  - 每季度: 用户满意度调研
  - 每年: 系统全面优化
```

### 8. 特殊情况处理

#### 新用户处理
```
特征: 无历史数据，画像不明确
策略:
  1. 使用通用推荐模板
  2. 提供更广泛的选项范围
  3. 主动询问澄清需求
  4. 快速学习建立画像
```

#### 矛盾需求处理
```
场景: 用户要求"最好最便宜"
策略:
  1. 解释"性价比"概念
  2. 提供梯度选择：最便宜→性价比最高→最好
  3. 说明各选项的 trade-off
  4. 建议基于实际需求选择
```

#### 紧急需求处理
```
特征: 时间紧迫，需要快速决策
策略:
  1. 提供精简版推荐（3个核心选项）
  2. 突出关键决策因素
  3. 减少详细信息，聚焦核心
  4. 提供快速预订指引
```

## 实施检查清单

### 推荐前检查
- [ ] 用户画像识别完成
- [ ] 需求维度分析完整
- [ ] 候选酒店池充足（>20个）
- [ ] 实时数据验证通过

### 推荐中检查
- [ ] 评分计算准确
- [ ] 权重调整合理
- [ ] 多样性要求满足
- [ ] 个性化过滤应用

### 推荐后检查
- [ ] 选项数量达标（≥5个）
- [ ] 解释说明清晰
- [ ] 风险提示到位
- [ ] 反馈机制可用

---

通过这个个性化推荐引擎，skill可以智能地理解和服务不同维度的用户需求，提供真正精准、有用、个性化的酒店推荐服务。