# 中国酒店比价 Skill

## 简介

中国酒店比价 - 专门针对美团、去哪儿、携程、飞猪、途牛等中国本土平台的酒店搜索、价格比较、套餐分析和个性化推荐服务。

## 核心特色

### 🎯 强制不少于5个选项 + 个性化匹配
- 每次搜索必须提供不少于5个精选酒店选项
- 基于用户画像的个性化推荐匹配
- 确保选项多样性：不同价格、类型、平台、特色
- 覆盖全面：从经济型到舒适型，从连锁到特色民宿

### 👤 多维度用户画像识别 + 历史学习
- **智能画像分类**：家庭、商务、旅游、度假、学生等
- **历史行为分析**：记录和分析用户搜索、筛选、选择习惯
- **需求维度学习**：从历史中学习预算、平台、评价等偏好
- **持续学习优化**：基于历史反馈的智能优化和预测

### 🏨 多平台深度整合
- **携程**：全品类覆盖，商务出行首选
- **去哪儿**：价格优势明显，比价功能强大
- **美团**：本地生活整合，优惠活动多
- **飞猪**：阿里生态，会员权益丰富
- **途牛**：旅游套餐，度假酒店专业

### 💰 智能价格计算 + 个性化评分
- 总成本计算（含所有隐藏费用）
- 7维度个性化评分系统
- 实时价格验证和监控
- 优惠券和会员权益智能评估

## 快速开始

### 触发条件
当用户需要在中国境内寻找酒店、比较不同平台价格、获取最佳预订建议时，自动触发此skill。

### 典型使用场景
```
用户："帮我找一下上海迪士尼附近的酒店，预算500以内"
用户："北京王府井有什么推荐的酒店？"
用户："比较一下广州长隆附近的住宿"
用户："三亚有什么性价比高的酒店推荐？"
```

### 输出格式
每次提供不少于5个精选选项，每个选项包含：
- 酒店基本信息（名称、位置、评分）
- 多平台价格对比
- 总成本计算
- 优缺点分析
- 适合人群说明
- 预订建议

## 文件结构

```
domestic-hotel-comparison/
├── SKILL.md                    # 主技能文件
├── search-strategy.md          # 搜索策略指南
├── price-calculation.md        # 价格计算模型
├── user-profiles.md            # 多维度用户画像系统
├── user-history-learning.md    # 用户历史学习系统
├── personalized-recommendation.md # 个性化推荐引擎
├── user-preferences.md         # 用户偏好管理
├── scripts/hotel-search-example.sh # 搜索脚本示例
├── _meta.json                  # 元数据
└── README.md                   # 本文件
```

## 工作流程

### 1. 需求收集
- 目的地、日期、人数、预算、特殊需求

### 2. 多平台搜索
- 每个平台搜索5-8个候选酒店
- 建立20-30个酒店的候选池

### 3. 数据整理
- 价格归一化（统一计算总成本）
- 价值评估（价格vs服务vs位置）
- 风险识别（取消政策、评价真实性）

### 4. 个性化分析和精选推荐
- 用户画像识别和需求分析
- 多维度个性化评分和过滤
- 从候选池精选不少于5个最佳选项
- 确保选项多样性和个性化匹配
- 提供详细比较和个性化推荐理由

## 独特价值

### 1. 中国本土化
- 专门针对中国用户习惯和平台
- 理解中国节假日和旅游旺季
- 熟悉中国本土酒店品牌和连锁

### 2. 实用性优先
- 基于真实用户需求设计
- 经过实际测试和优化
- 提供可操作的预订建议

### 3. 透明度保证
- 明确展示所有费用
- 清晰说明取消政策
- 真实评价参考

## 适用人群

### 🎪 家庭出游
- 关注儿童设施和安全
- 需要家庭房型
- 重视位置便利性

### 💼 商务出行
- 需要商务设施和发票
- 重视交通便利
- 关注服务品质

### 🎒 自由行游客
- 价格敏感
- 需要交通便利
- 喜欢特色体验

### 🏝️ 度假游客
- 关注度假设施
- 需要特色体验
- 重视环境和服务

## 技术特点

### 个性化分析
- 多维度用户画像识别
- 历史行为学习和预测
- 习惯模式分析和优化
- 持续学习和自适应

### 搜索策略
- 多平台并行搜索
- 智能筛选算法
- 实时数据验证

### 价格计算
- 完整费用模型
- 优惠叠加计算
- 性价比评估

### 推荐算法
- 7维度个性化评分系统
- 动态权重调整算法
- 智能过滤匹配规则
- 多样性保证机制

## 社区贡献

### 欢迎贡献
- 添加新的中国本土平台支持
- 优化搜索策略
- 完善价格计算模型
- 增加地区特色酒店知识

### 反馈渠道
- 通过ClawHub社区反馈
- 提交改进建议
- 分享使用经验

## 版本历史

### v1.2.0 (2026-02-25)
- 新增用户历史学习系统
- 支持基于历史需求和筛选习惯的智能优化
- 添加行为模式分析和预测功能
- 完善持续学习和自适应机制

### v1.1.0 (2026-02-25)
- 新增多维度个性化推荐功能
- 支持用户画像识别和智能匹配
- 添加7维度评分系统和个性化过滤
- 完善个性化推荐引擎和算法

### v1.0.1 (2026-02-25)
- 强制要求每次筛选结果不少于5个选项
- 更新搜索策略和推荐格式
- 完善文档和示例

### v1.0.0 (2026-02-25)
- 初始版本发布
- 支持5个中国本土平台
- 完整的比价工作流程

## 许可证

本skill遵循开源协议，欢迎社区使用和改进。

---

**让国内酒店比价更智能、更全面、更实用！**