# 中国平台搜索关键词模式

## 平台搜索策略

### 小红书

**搜索方式**：
- 关键词搜索笔记
- 笔记下评论抓取
- 话题标签搜索

**搜索特点**：
- 真实体验分享
- 详细使用反馈
- 女性用户占比高

### 抖音

**搜索方式**：
- 视频关键词搜索
- 视频评论抓取
- 话题标签搜索

**搜索特点**：
- 即时吐槽
- 情绪表达强烈
- 年轻用户群体

### 微博

**搜索方式**：
- 话题搜索
- 关键词搜索
- 超话社区

**搜索特点**：
- 深度讨论
- 观点鲜明
- 话题传播快

### 淘宝/京东

**搜索方式**：
- 商品评价抓取
- 差评筛选
- 追评分析

**搜索特点**：
- 真实购买用户
- 差评价值高
- 产品质量问题

### 视频号

**搜索方式**：
- 视频关键词
- 视频评论

**搜索特点**：
- 成熟用户群体
- 内容务实
- 传播力强

## 抱怨类关键词库

### 强烈不满

```
[产品] 垃圾
[产品] 太烂了
[产品] 坑
[产品] 真的服了
[产品] 无语
受够了 [产品]
再也不用 [产品]
[产品] 劝退
[产品] 差评
[产品] 踩雷
```

### 中度不满

```
[产品] 难用
[产品] 不好用
[产品] 体验差
[产品] 有问题
[产品] bug
[产品] 卡
[产品] 慢
[产品] 闪退
[产品] 失望
[产品] 后悔
```

### 功能期望

```
希望 [产品] 能
[产品] 要是能
[产品] 什么时候支持
[产品] 缺少
[产品] 没有
为什么 [产品] 不能
[产品] 应该有
期待 [产品]
建议 [产品]
[产品] 能不能
```

### 迁移信号

```
从 [产品] 换到
弃用 [产品]
不用 [产品] 了
[产品] 替代品
比 [产品] 好用
[产品] 平替
转投 [产品]
[产品] 竞品
[产品] vs [竞品]
```

### 价格相关（实物需求）

```
[产品] 太贵
[产品] 不值
[产品] 性价比
[产品] 收费
[产品] 涨价
[产品] 订阅
[产品] 划算吗
[产品] 值得买吗
```

### 质量相关（实物需求）

```
[产品] 质量差
[产品] 假货
[产品] 瑕疵
[产品] 坏了
[产品] 不耐用
[产品] 材质差
[产品] 做工差
[产品] 和图片不符
```

## 组合搜索模式

### 模式 1: 基础抱怨搜索

```
[产品] (垃圾 OR 差评 OR 难用 OR 坑)
```

### 模式 2: 功能需求搜索

```
[产品] (希望能 OR 要是能 OR 为什么不能 OR 缺少)
```

### 模式 3: 迁移行为搜索

```
(从 [产品] 换到 OR 弃用 [产品] OR [产品] 替代品)
```

### 模式 4: 价格敏感搜索（实物需求）

```
[产品] (太贵 OR 不值 OR 性价比 OR 划算)
```

### 模式 5: 竞品对比搜索

```
[产品] vs [竞品]
[产品] 比 [竞品]
[产品] 和 [竞品] 对比
```

## 按产品类型的搜索策略

### 实物产品

```
# 质量问题
[产品] (质量差 OR 假货 OR 瑕疵 OR 坏了)

# 使用体验
[产品] (难用 OR 不好用 OR 体验差)

# 价格问题
[产品] (太贵 OR 不值 OR 性价比)

# 售后问题
[产品] (售后 OR 客服 OR 退换)
```

### 服务/内容产品

```
# 功能问题
[产品] (功能 OR 缺少 OR 没有)

# 体验问题
[产品] (难用 OR 复杂 OR 不直观)

# 内容问题
[产品] (内容少 OR 质量差 OR 更新慢)

# 价格问题
[产品] (太贵 OR 不值 OR 订阅)
```

### APP/软件

```
# 性能问题
[产品] (卡 OR 慢 OR 闪退 OR 崩溃)

# 功能问题
[产品] (缺少 OR 没有 OR 希望能)

# 体验问题
[产品] (难用 OR 复杂 OR 不直观)

# 更新问题
[产品] (更新 OR 新版本) (差 OR 不好 OR 问题)
```

## 时间过滤

**近期数据**：
- 过去一周
- 过去一月
- 过去三月

**季节性考虑**：
- 促销期间（双11、618）
- 考试季节（考公、考研）
- 节假日期间

## 高级技巧

### 1. 排除无关结果

```
[产品] 难用 -广告 -推广 -软文
```

### 2. 精确匹配

```
"[产品名称]" (用引号确保精确匹配)
```

### 3. 同时搜索多个竞品

```
(产品A OR 产品B OR 产品C) (难用 OR 差评)
```

### 4. 发现讨论帖

```
[产品] (怎么样 OR 好用吗 OR 值得买吗 OR 测评)
```

### 5. 发现真实体验

```
[产品] (真实体验 OR 使用感受 OR 踩雷 OR 避坑)
```

## 平台特定搜索

### 小红书搜索

```
# 笔记搜索
[产品] 真实体验
[产品] 踩雷
[产品] 避坑指南
[产品] 测评

# 评论搜索
[产品] 差评
[产品] 吐槽
```

### 抖音搜索

```
# 视频搜索
[产品] 吐槽
[产品] 避雷
[产品] 真实测评
[产品] 翻车

# 评论搜索
[产品] 垃圾
[产品] 骗子
```

### 微博搜索

```
# 话题搜索
#[产品]#
#[产品]吐槽#
#[产品]避雷#

# 关键词搜索
[产品] 差评
[产品] 垃圾
```

### 淘宝搜索

```
# 差评筛选
[产品] 差评
[产品] 踩雷
[产品] 假货
[产品] 质量差

# 追评搜索
[产品] 追评
[产品] 用后感
```
