# {report_title}

## 1. 执行摘要

### 1.1 数据抓取概况
- **抓取时间**：{fetch_time}
- **数据来源**：{data_sources}
- **总数据量**：{total_data_count} 条
- **有效需求数**：{total_demands} 条

### 1.2 核心发现
{core_findings}

### 1.3 关键需求概览
{key_demands}

## 2. 数据来源与方法

### 2.1 数据源列表
{data_sources_list}

### 2.2 数据抓取时间范围
{time_range}

### 2.3 数据清洗方法
- **去重处理**：去除重复内容
- **过滤无效数据**：删除广告、垃圾信息
- **文本清洗**：去除表情符号和特殊字符
- **数据标注**：情感倾向、需求类型、紧急程度

### 2.4 分析方法说明
- **需求提取**：基于关键词匹配和情感分析
- **需求分类**：功能需求、体验需求、服务需求、内容需求
- **优先级评估**：综合频率、情感强度、影响范围

## 3. 用户反馈分析

### 3.1 总体反馈情况
- **正面反馈**：{positive_count} 条 ({positive_ratio:.1%})
- **负面反馈**：{negative_count} 条 ({negative_ratio:.1%})
- **中性反馈**：{neutral_count} 条 ({neutral_ratio:.1%})

### 3.2 情感分析结果
{sentiment_analysis}

### 3.3 各平台反馈特点
{platform_characteristics}

## 4. 需求提取结果

### 4.1 需求分类统计
{demand_type_stats}

### 4.2 需求详细列表
{demand_list}

### 4.3 需求关联分析
{demand_correlation}

## 5. 需求分级与优先级

### 5.1 P0级需求（紧急重要）
**定义**：影响核心功能使用的问题、用户投诉集中的问题、安全或合规相关的问题、出现频率 > 15次

{p0_demands}

### 5.2 P1级需求（重要不紧急）
**定义**：影响用户体验但非核心功能、用户多次提及的改进建议、出现频率 8-15次

{p1_demands}

### 5.3 P2级需求（紧急不重要）
**定义**：边缘功能的问题、少数用户的需求、出现频率 3-7次

{p2_demands}

### 5.4 P3级需求（不紧急不重要）
**定义**：个性化需求、长期优化建议、出现频率 < 3次

{p3_demands}

## 6. 建议与行动计划

### 6.1 短期行动建议（1-3个月）
{short_term_actions}

### 6.2 中期规划建议（3-6个月）
{mid_term_actions}

### 6.3 长期战略建议（6个月以上）
{long_term_actions}

## 7. 附录

### 7.1 原始数据样本
{data_samples}

### 7.2 分析方法说明
{analysis_methods}

### 7.3 参考资料
- **数据来源**：各平台公开数据
- **分析工具**：Python + 自然语言处理
- **生成时间**：{generation_time}

---

**报告说明**：本报告基于真实用户反馈数据生成，所有数据均已进行脱敏处理。报告内容仅供内部参考使用。
