---
name: china-demand-mining
description: |
  中国公域新媒体平台需求挖掘技能。从抖音、小红书、淘宝等平台抓取用户评论和反馈数据，根据需求类型（实物需求/无实物需求）智能选择数据源，特别关注小红书用户评论和电商差评，进行需求分析和分级，生成用户需求调研报告。
  
  触发场景：
  - 用户说"帮我挖掘 XX 领域/产品的用户需求"
  - 用户说"分析 XX 产品的用户抱怨"
  - 用户说"看看用户对 XX 有什么不满"
  - 用户说"找找 XX 领域的痛点"
  - 用户说"调研 XX 市场机会"
  - 用户说"分析 XX 群体的情绪和需求"
---

# 中国公域新媒体需求挖掘

从中国主流社交平台挖掘用户真实声音，发现产品需求和市场机会。

## 核心原则

### 数据量要求
- **最低要求**：每次需求挖掘必须至少抓取 **2000条** 清洗后的有效用户需求
- **越多越好**：数据量越大，需求分析越准确
- **统计置信度**：2000条数据达到95%置信度

### 智能数据源选择

根据需求类型自动选择最合适的数据源：

**实物需求**（产品/商品相关）：
- **必选平台**：小红书、抖音、淘宝（优先级最高）
- **可选平台**：京东、拼多多、微博
- **数据重点**：产品评价、使用体验、差评分析

**无实物需求**（服务/内容/功能相关）：
- **必选平台**：小红书、抖音、微博
- **可选平台**：视频号、知乎
- **数据重点**：用户评论、话题讨论、功能反馈
- **注意**：不去电商平台抓取数据

## 工作流程

### Step 1: 明确挖掘目标

向用户确认：

1. **挖掘对象**: 特定产品还是领域
2. **需求类型**: 实物需求还是无实物需求
3. **竞品范围**: 是否分析竞品的用户反馈
4. **时间范围**: 近期（1个月）还是更长时间

### Step 2: 判断需求类型与选择数据源

**实物需求特征**：
- 涉及具体产品或商品
- 用户关注产品质量、功能、价格
- 适合从电商平台抓取评价数据

**无实物需求特征**：
- 涉及服务、内容或功能
- 用户关注体验、效率、便捷性
- 不适合从电商平台抓取数据

**数据源分配**（总计2000+条）：

| 需求类型 | 平台 | 数据量 | 权重 |
|----------|------|--------|------|
| 实物需求 | 小红书 | 600-800条 | 35% |
| 实物需求 | 抖音 | 400-600条 | 25% |
| 实物需求 | 淘宝 | 600-1000条 | 30% |
| 实物需求 | 京东 | 200-400条 | 15% |
| 无实物需求 | 小红书 | 800-1000条 | 40% |
| 无实物需求 | 抖音 | 600-800条 | 30% |
| 无实物需求 | 微博 | 400-600条 | 20% |
| 无实物需求 | 视频号 | 200-400条 | 10% |

### Step 3: 构建搜索策略

根据目标构建多维度搜索查询，参见 [SEARCH_PATTERNS.md](references/SEARCH_PATTERNS.md)。

**抱怨类关键词**：
- `[产品] 难用 / 垃圾 / 坑 / 吐槽`
- `[产品] 问题 / bug / 闪退`
- `弃用 [产品] / 从 [产品] 换到`
- `希望 [产品] 能 / [产品] 要是能`
- `[产品] 替代品 / 比 [产品] 好用`

**平台搜索策略**：

| 平台 | 搜索方式 | 特点 |
|------|----------|------|
| 小红书 | 关键词搜索笔记和评论 | 真实体验、详细反馈 |
| 抖音 | 视频关键词和评论 | 即时吐槽、情绪强烈 |
| 微博 | 话题搜索 | 深度讨论、观点鲜明 |
| 淘宝 | 商品评价和差评 | 真实购买、差评价值高 |
| 视频号 | 视频评论 | 成熟用户、内容务实 |

### Step 4: 执行数据抓取与清洗

**数据抓取要求**：
- 原始数据抓取量：至少 **3000-5000条**
- 清洗后有效数据：至少 **2000条**
- 优先抓取负面反馈和差评（占比不低于40%）

**数据清洗步骤**：
1. 去重：去除重复内容（相似度>80%视为重复）
2. 过滤无效：删除广告、垃圾信息、字数少于5字的评论
3. 文本清洗：去除表情符号和特殊字符
4. 数据标注：情感倾向、需求类型、紧急程度

### Step 5: 分析与分类

将收集的用户声音按维度分类，参见 [ANALYSIS_FRAMEWORK.md](references/ANALYSIS_FRAMEWORK.md)。

**分类体系**：

1. **功能缺失** - 用户想要但产品没有的功能
2. **体验问题** - 使用中的摩擦和痛点
3. **性能问题** - 速度、稳定性、兼容性
4. **定价问题** - 价格、性价比、付费模式（实物需求）
5. **内容问题** - 内容质量、数量问题（无实物需求）
6. **竞品对比** - 用户为什么选择/离开

**评估维度**：

| 维度 | 等级 | 标准 |
|------|------|------|
| 频次 | 高频 | 50+ 条独立反馈 |
| 频次 | 中频 | 20-50 条独立反馈 |
| 频次 | 低频 | <20 条独立反馈 |
| 情绪强度 | 强烈 | 垃圾、坑死、崩溃 |
| 情绪强度 | 中等 | 难用、失望、烦 |
| 情绪强度 | 轻微 | 希望、建议、期待 |
| 可操作性 | 高 | 可直接转化为产品任务 |
| 可操作性 | 中 | 需进一步调研 |
| 可操作性 | 低 | 过于模糊或主观 |

### Step 6: 需求分级与优先级

根据频次 × 情绪强度 × 可操作性 确定优先级：

**P0级（紧急重要）**：
- 出现频率 > 100次（占比 > 5%）
- 负面比例 > 50%
- 影响核心功能使用

**P1级（重要不紧急）**：
- 出现频率 50-100次（占比 2.5-5%）
- 负面比例 30%-50%
- 影响用户体验

**P2级（紧急不重要）**：
- 出现频率 20-50次（占比 1-2.5%）
- 负面比例 < 30%
- 边缘功能问题

**P3级（不紧急不重要）**：
- 出现频率 < 20次（占比 < 1%）
- 个性化需求
- 长期优化建议

### Step 7: 生成报告

输出结构化 Markdown 报告，参见 [REPORT_TEMPLATE.md](references/REPORT_TEMPLATE.md)。

## 输出格式

### 需求挖掘报告

```markdown
# [产品/领域] 需求挖掘报告

**生成时间**: YYYY-MM-DD
**需求类型**: 实物需求 / 无实物需求
**数据来源**: 小红书, 抖音, 微博, ...
**样本量**: 分析了 N 条用户反馈

---

## 执行摘要

> 3-5 句话总结核心发现

### 关键数字

| 指标 | 数值 |
|------|------|
| 分析反馈总数 | N |
| 高频痛点数量 | N |
| 发现的产品机会 | N |
| 强烈不满占比 | X% |

---

## 一、Top 5 用户痛点

| 排名 | 痛点 | 分类 | 频次 | 情绪 | 典型声音 |
|------|------|------|------|------|----------|
| 1 | [痛点描述] | 功能缺失 | 高 | 强烈 | "..." |

---

## 二、产品机会矩阵

| 机会点 | 用户需求本质 | 现有方案不足 | 建议方向 | 优先级 |
|--------|--------------|--------------|----------|--------|
| [机会1] | [需求] | [不足] | [建议] | P0 |

---

## 三、详细分析

### 3.1 功能缺失类

#### 3.1.1 [功能需求名称]

**频次**: 高/中/低 | **情绪**: 强烈/中等/轻微 | **可操作性**: 高/中/低

**用户原声:**
> "引用用户原话..." — [平台] | [时间] | 👍 123

**需求分析:**
用户真正想要的是...背后的本质需求是...

**产品建议:**
1. 短期：...
2. 长期：...

---

## 四、行动建议

### 立即可做（Quick Wins）
1. **[建议1]**: [具体说明]

### 中期规划（1-3个月）
1. **[建议1]**: [具体说明]

### 需要进一步调研
1. **[问题1]**: [为什么需要更多调研]

---

## 五、数据来源明细

| 平台 | 搜索关键词 | 有效反馈 | 链接汇总 |
|------|------------|----------|----------|
| 小红书 | [keywords] | N | [查看](#) |
| 抖音 | [keywords] | N | [查看](#) |
```

## 最佳实践

1. **数据量保证**: 必须确保清洗后至少2000条有效数据
2. **平台选择**: 根据需求类型选择合适的数据源
3. **原文引用**: 保留用户原话，避免过度解读
4. **注明来源**: 每条发现都标注出处
5. **量化呈现**: 用频次、比例说明问题普遍性
6. **可操作性**: 将痛点转化为具体产品建议

## 参考资料

- [ANALYSIS_FRAMEWORK.md](references/ANALYSIS_FRAMEWORK.md) - 完整分析框架和分类标准
- [REPORT_TEMPLATE.md](references/REPORT_TEMPLATE.md) - 报告模板详细说明
- [SEARCH_PATTERNS.md](references/SEARCH_PATTERNS.md) - 中国平台搜索关键词模式
- [PLATFORM_SELECTION.md](references/PLATFORM_SELECTION.md) - 平台选择策略
