
import argparse
import requests
import sys
import os

def main():
    parser = argparse.ArgumentParser(description="Client for Qwen3 TTS Service")
    parser.add_argument("text", help="Text to synthesize")
    parser.add_argument("-l", "--language", default="Chinese", help="Language code (default: Chinese)")
    parser.add_argument("-o", "--output", default="output.wav", help="Output WAV file path")
    parser.add_argument("--url", default="http://localhost:9090", help="Service URL (default: http://localhost:9090)")
    
    args = parser.parse_args()
    
    endpoint = f"{args.url.rstrip('/')}/synthesize"
    payload = {
        "text": args.text,
        "language": args.language
    }
    
    print(f"Sending request to {endpoint}...")
    try:
        response = requests.post(endpoint, json=payload, stream=True)
        response.raise_for_status()
        
        with open(args.output, "wb") as f:
            for chunk in response.iter_content(chunk_size=8192):
                f.write(chunk)
        
        print(f"Success! Audio saved to: {os.path.abspath(args.output)}")
        
    except requests.exceptions.ConnectionError:
        print(f"Error: Could not connect to service at {args.url}. Is the server running?")
        sys.exit(1)
    except Exception as e:
        print(f"Error: {e}")
        sys.exit(1)

if __name__ == "__main__":
    main()
