---
name: check-analytics
description: Audit existing Google Analytics implementation. Checks for common issues, missing configurations, and optimization opportunities.
---

# Analytics Audit Skill

You are auditing the Google Analytics implementation in this project.

## Step 1: Find Existing Analytics

Search for analytics code:
- `gtag` or `dataLayer` references
- Google Tag Manager (`GTM-`)
- Universal Analytics (`UA-`) - deprecated
- GA4 Measurement IDs (`G-`)
- Third-party analytics (Mixpanel, Amplitude, Plausible, etc.)

## Step 2: Generate Audit Report

Create a report with these sections:

### Current Setup
- Framework detected
- Analytics provider(s) found
- Measurement ID(s) found (redact last 6 chars for security: `G-XXXX******`)
- Implementation method (gtag.js, GTM, npm package)

### Issues Found

Check for:
1. **Deprecated UA properties** - Universal Analytics sunset July 2024
2. **Missing pageview tracking** for SPAs
3. **Hardcoded Measurement IDs** (should use env vars)
4. **Missing TypeScript types** for gtag
5. **No consent mode** implementation
6. **Debug mode in production** (check for `debug_mode: true`)
7. **Duplicate script loading**
8. **Missing error boundaries** around analytics code
9. **Blocking script loading** (should be async)
10. **No fallback** for ad-blocker scenarios

### Recommendations

Provide actionable fixes ranked by priority:
- 🔴 Critical (breaking/deprecated)
- 🟡 Warning (best practice violations)
- 🟢 Suggestion (optimizations)

### Event Coverage Analysis

List custom events being tracked and suggest missing ones:
- Sign up / Login events
- Purchase/conversion events
- Form submissions
- Error tracking
- Key user interactions

## Output Format

```markdown
# Analytics Audit Report

## Summary
- **Status**: [Healthy / Needs Attention / Critical Issues]
- **Provider**: [GA4 / GTM / Other]
- **Framework**: [detected framework]

## Current Implementation
[describe what was found]

## Issues

### 🔴 Critical
[list critical issues]

### 🟡 Warnings
[list warnings]

### 🟢 Suggestions
[list suggestions]

## Event Coverage
| Event Type | Status | Recommendation |
|------------|--------|----------------|
| Page Views | ✅ | - |
| Sign Up | ❌ | Add sign_up event |
| ... | ... | ... |

## Next Steps
1. [ordered action items]
```
