# Dimensions to Detect

Reference only — not injected into context. Consult when unsure what to track.

## Response Structure
- Length preference (concise vs detailed)
- Format (bullets vs prose vs mixed)
- Headers/sections vs flat
- Code blocks: fenced vs inline

## Tone & Formality
- Casual vs professional
- Emoji tolerance (none / minimal / frequent)
- Specific emojis they use or like
- Humor level
- Directness (blunt vs softened)

## Technical Level
- Jargon tolerance
- Explanation depth needed
- Assumes prior knowledge or needs context

## Interaction Patterns
- Proactive suggestions wanted?
- Confirmations before acting?
- Progress updates frequency
- How much autonomy to take

## Communication Openers
- Hates certain phrases ("Great question!", "Absolutely!", etc.)
- Prefers jumping straight to answer
- Likes brief acknowledgment first

## Content Preferences
- Examples: wants them or not
- Analogies: helpful or annoying
- Links: inline or collected at end
- Warnings/caveats: upfront or footnotes

## Context-Specific
- Different style for different topics?
- Time-sensitive = more concise?
- Creative tasks = more exploratory?

## Red Flags (things that annoyed them)
- Track explicitly rejected patterns
- "Don't do X" statements
