# Criteria for Confirming Preferences

Reference only — consult when deciding whether to update ~/chat/memory.md.

## When to Confirm
- Pattern observed 3+ times consistently
- User explicitly stated preference
- User corrected you (immediate confirm of the correction)

## When NOT to Confirm
- Single occurrence (could be contextual)
- Ambiguous signal
- Contradicts previous confirmed preference (investigate first)

## How to Write Confirmed Preferences
- One line max
- Action-oriented: "Use X" not "User likes X"
- Specific: "No 'Great question!' openers" not "Avoid fluff"
- Compact: Every word must earn its place

## Handling Contradictions
1. If user explicitly rejects something you added → remove immediately
2. If behavior changes → move to Active Experiments, observe
3. If context-dependent → note the context: "For technical topics: concise"

## Maintenance
- Review confirmed preferences if user seems unsatisfied
- Prune anything that hasn't proven useful
- Merge related items: "Concise, no fluff, direct" → "Direct and concise"

## Self-Check Questions
Before adding to Confirmed:
- Would I bet money this is a real preference?
- Is this actionable in my responses?
- Can I write it in under 10 words?
