---
name: charisma-research-loop
description: Generate daily high-signal charisma/engagement insights with a self-improving novelty loop. Use when sending recurring tips on charisma, body language, oration, psychology, influence, persuasion, manipulation-awareness, social dynamics, or communication performance; especially for scheduled morning/night briefs with email/calendar delivery.
---

# Charisma Research Loop

Use this workflow to avoid shallow repeated advice and continuously improve insight quality.

## Output contract
- Produce exactly 5 insights per run.
- Make each insight specific, testable, and action-oriented.
- Include these fields for each insight:
  1) Theme
  2) Insight
  3) Why it works
  4) 24h experiment
  5) Failure mode / misuse risk

## Theme rotation
Rotate themes so consecutive runs are not repetitive.
Use this pool:
- Body language and non-verbal signaling
- Oration and vocal delivery
- Social psychology and status dynamics
- Ethical persuasion and influence
- Manipulation detection and defense
- Conversation architecture and storytelling
- Presence under pressure (meetings, conflict, negotiation)

## Source depth rules
- Prefer synthesis over quotes.
- Pull from mixed source types each run (discussion + educational + behavioral science).
- Do not rely on only surface-level generic tips.
- Convert raw source material into deeper mechanisms and practical tests.

## Self-improving loop (mandatory)
Before generating a new run:
1. Read `/root/.openclaw/workspace/memory/charisma-insight-ledger.md`.
2. Identify what was already sent recently and mark those clusters as `DONE` in today’s section when superseded.
3. Choose at least 3 new angles not used in the most recent 3 runs.
4. Generate the new 5-insight set.
5. Append a compact run log to the ledger:
   - timestamp
   - themes used
   - novelty score (1-10)
   - repeated ideas avoided
   - one improvement for next run

## Delivery
- Send concise email brief with the 5 insights.
- Create/update calendar task/event containing same 5 insights.
- Keep wording practical, direct, non-fluffy.
