# Retention and Engagement

## Retention Framework

### Time-Based Cohorts
- **Day 1** — First session completion, core action taken
- **Week 1** — Return visits, habit signals
- **Month 1** — Sustained usage, feature depth
- **Long-term** — Plateau identification, power user patterns

### Benchmarks by Product Type

| Type | D1 | D7 | D30 | Good |
|------|-----|-----|-----|------|
| Social | 40% | 20% | 10% | Above average |
| SaaS B2B | 60% | 40% | 25% | Healthy |
| E-commerce | 20% | 10% | 5% | Normal |
| Gaming casual | 35% | 15% | 5% | Standard |

## Engagement Levers

### Habit Formation
- **Trigger** — External (notification) or internal (emotion) cue
- **Action** — Simple behavior with low friction
- **Variable reward** — Unpredictable positive outcome
- **Investment** — User effort that increases future value

### Re-engagement
- **Email sequences** — Onboarding drips, win-back campaigns
- **Push notifications** — Personalized, timed, limited frequency
- **In-app triggers** — Feature announcements, usage milestones
- **Retargeting** — Bring back churned or dormant users

## Churn Analysis

### Warning Signals
- Usage frequency decline
- Feature breadth narrowing
- Support ticket patterns
- Payment failures
- Competitor mentions

### Intervention Timing
- **Early signals** — Proactive outreach, feature education
- **At-risk** — Personalized offers, success calls
- **Churned** — Win-back campaigns, exit surveys

## Activation Connection

Retention problems often trace to activation failures:
- Users who don't reach aha moment churn faster
- First session depth predicts long-term retention
- Onboarding friction creates false churn signals
