# Growth Metrics and Analysis

## North Star Metrics

### By Business Model

| Model | North Star | Why |
|-------|------------|-----|
| SaaS | Weekly active users | Usage predicts retention |
| Marketplace | GMV / transactions | Core value exchange |
| Media | Time spent | Attention monetization |
| E-commerce | Orders per period | Revenue driver |
| Social | DAU/MAU ratio | Engagement intensity |

### North Star Criteria
- Measures value delivered to users
- Leading indicator of revenue
- Actionable by the team
- Simple to understand

## Funnel Metrics

### AARRR Framework
- **Acquisition** — How users find you (traffic, signups)
- **Activation** — First value moment (onboarding completion, aha moment)
- **Retention** — Users come back (DAU/WAU/MAU, cohort curves)
- **Revenue** — Users pay (conversion rate, ARPU, LTV)
- **Referral** — Users invite others (viral coefficient, NPS)

## Unit Economics

### Customer Acquisition Cost (CAC)
```
CAC = Total acquisition spend / New customers acquired
```

### Lifetime Value (LTV)
```
LTV = ARPU × Gross margin × Average customer lifespan
```

### LTV:CAC Ratio
- **< 1:1** — Losing money on every customer
- **1:1 - 3:1** — Sustainable but tight
- **3:1+** — Healthy, room to invest in growth
- **5:1+** — Under-investing in growth

### Payback Period
```
Payback months = CAC / (ARPU × Gross margin)
```
- **< 12 months** — Good for venture-backed
- **< 6 months** — Excellent, accelerate

## Cohort Analysis

### Building Cohorts
- Group users by signup week/month
- Track behavior over time
- Compare cohorts to each other

### What to Look For
- Retention curve shape (steep drop vs gradual)
- Plateau point (where retention stabilizes)
- Cohort improvements (are new users better)
- Seasonal effects (holiday cohorts differ)

## Dashboard Essentials

### Weekly Review
- North star metric trend
- Funnel conversion rates
- Acquisition by channel
- Retention cohort update
- Experiment results

### Monthly Deep Dive
- Unit economics health
- Channel performance comparison
- Segment analysis
- Growth model accuracy
- Forecast vs actual
