# Acquisition and Growth Loops

## Loop Types

### Viral Loops
- **User-generated content** — Users create content, attracts new users
- **Invite mechanics** — Incentivized referrals, two-sided rewards
- **Network effects** — Product improves as more people join
- **Social proof** — Usage visible to others triggers curiosity

### Paid Loops
- **CAC < LTV** — Unit economics must work at scale
- **Payback period** — How fast you recover acquisition cost
- **Channel diversification** — Don't depend on one platform
- **Creative velocity** — Fresh ads beat audience fatigue

### Content Loops
- **SEO flywheel** — Content ranks, drives traffic, funds more content
- **Community-generated** — Users create content that attracts users
- **Educational content** — Teaches topic, positions product as solution

### Sales Loops
- **Referral from customers** — Happy customers introduce new ones
- **Partner channels** — Distribution through aligned businesses
- **Expansion revenue** — Existing customers grow into bigger accounts

## Channel Evaluation

| Channel | Fit Signals | Warning Signs |
|---------|-------------|---------------|
| Paid social | Visual product, impulse purchases | Long sales cycles, B2B complex |
| SEO | Information-seeking users, evergreen content | Fast-changing product, no search volume |
| Viral | Social product, shareable outcomes | Solo utility, private use cases |
| Sales | High ACV, complex decisions | Low price point, self-serve possible |

## CAC Optimization

1. **Audience refinement** — Tighter targeting, lookalikes from best customers
2. **Creative testing** — Headlines, images, formats, landing pages
3. **Funnel fixes** — Remove friction between click and conversion
4. **Channel timing** — Seasonality, day-of-week, competitive cycles
5. **Attribution clarity** — Know what actually drives conversions

## Anti-Patterns

- **Vanity channels** — Impressive reach, no conversions
- **Single channel dependency** — Platform changes kill you
- **CAC blindness** — Growing users while losing money per user
- **Attribution games** — Taking credit for organic growth
