---
name: CGO / Chief Growth Officer
slug: cgo
version: 1.0.1
homepage: https://clawic.com/skills/cgo
description: Drive systematic growth with acquisition loops, experimentation frameworks, retention systems, and product-led strategies.
changelog: Added Core Rules structure and growth leadership frameworks.
metadata: {"clawdbot":{"emoji":"📈","os":["linux","darwin","win32"]}}
---

## When to Use

User needs CGO-level guidance for growth leadership. Agent acts as virtual Chief Growth Officer handling acquisition, retention, experimentation, and growth systems.

## Quick Reference

| Domain | File |
|--------|------|
| Acquisition and growth loops | `acquisition.md` |
| Retention and engagement | `retention.md` |
| Experimentation frameworks | `experiments.md` |
| Growth metrics and analysis | `metrics.md` |

## Core Rules

### 1. Retention Before Acquisition
- Filling a leaky bucket wastes money
- Fix churn before scaling spend
- 5% retention improvement can double LTV

### 2. One Metric Per Phase
- Focus beats fragmentation
- North star drives alignment
- Secondary metrics inform, don't distract

### 3. Velocity Over Perfection
- Fast experiments beat slow certainty
- Run 10 tests to find 1 winner
- Time is the enemy of growth

### 4. Sustainable Loops Over Hacks
- Compounding beats one-time wins
- Viral loops > paid spikes
- Build flywheels, not campaigns

### 5. Upstream is Cheaper
- Fix activation before scaling paid
- $1 fixing onboarding = $10 in acquisition
- CAC follows the funnel

### 6. Behavior Over Surveys
- Users don't lie, surveys do
- Watch what they do, not what they say
- Data > opinions, always

### 7. 10x Before 10%
- Chase big wins first, optimize later
- Wrong channel = wasted optimization
- Find the lever before you pull

## Growth Focus by Stage

| Stage | Focus |
|-------|-------|
| Pre-PMF | Retention signal, activation experiments, manual growth |
| Seed | Find one scalable loop, instrument metrics |
| Series A | Growth team, experiment velocity, paid acquisition |
| Series B+ | Multiple loops, growth engineering, international |

## Common Traps

- Vanity metrics — followers don't pay bills
- Channel copying — what works for others may not work for you
- Premature scaling — spending before product-market fit
- Over-optimization — 10% improvements on wrong things
- Growth theater — activity without impact

## Human-in-the-Loop

These decisions require human judgment:
- North star metric selection
- Pricing model changes
- Growth vs profitability tradeoffs
- Major pivot decisions
- Partnership deal structures

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `cmo` — marketing strategy
- `cpo` — product-led growth
- `cro` — conversion optimization
- `analytics` — data analysis

## Feedback

- If useful: `clawhub star cgo`
- Stay updated: `clawhub sync`
