# Financial Planning and Forecasting

## Planning Rhythm

| Cadence | Activity |
|---------|----------|
| Weekly | Cash flow update, AR/AP review |
| Monthly | Close books, variance analysis, forecast refresh |
| Quarterly | Board prep, scenario update, strategic review |
| Annually | Budget process, long-range plan |

## Forecasting Approaches

### Rolling Forecast (Preferred)

- Always looking 12-18 months ahead
- Update monthly, not annually
- Adapts to reality faster than static budgets

### Driver-Based Modeling

Connect operations to finance:

| Driver | Financial Impact |
|--------|------------------|
| Sales reps | Revenue capacity |
| Customers | Revenue, support costs |
| Engineers | Delivery capacity, payroll |
| Servers | Infrastructure costs |

**Formula example:** Revenue = Reps × Quota × Attainment %

### Scenario Planning

Maintain three scenarios:

| Scenario | Assumptions | Use |
|----------|-------------|-----|
| Best case | Everything works, market expands | Stretch targets |
| Base case | Realistic, some misses | Operating plan |
| Worst case | Key risks materialize | Contingency planning |

**Update quarterly** or when major assumptions change.

## Budget Process

### Timeline (for calendar year companies)

| Month | Activity |
|-------|----------|
| September | Strategic priorities set |
| October | Department inputs |
| November | Consolidation, trade-offs |
| December | Board approval |
| January | Execute |

### Common Mistakes

- Starting too late (cramped timeline)
- Bottom-up only (no strategic alignment)
- Top-down only (no operational reality)
- Zero-based every year (exhausting)
- Never zero-based (bloat accumulates)

## Variance Analysis

Monthly, explain significant variances:

```
Revenue: $950K actual vs $1M plan (-5%)
Cause: Deal slipped to next month (timing)
Impact: Expected to recover in Q2
Action: None required
```

**Categories:**
- Timing (will reverse)
- Volume (more/less activity)
- Rate (price/cost changes)
- Mix (different products/segments)

## Key Financial Metrics

| Metric | Formula | Benchmark |
|--------|---------|-----------|
| Gross margin | (Revenue - COGS) / Revenue | 70%+ SaaS |
| Burn rate | Monthly cash decrease | Runway dependent |
| CAC | Sales & marketing / New customers | < 1/3 LTV |
| LTV | ARPU × Gross margin × Lifetime | > 3x CAC |
| Rule of 40 | Growth % + Profit % | > 40% good |
