# Financial Operations

## Monthly Close Process

### Timeline (Target: 10 business days)

| Day | Activity |
|-----|----------|
| 1-3 | Transaction cutoff, preliminary data |
| 4-6 | Reconciliations, accruals |
| 7-8 | Review, adjustments |
| 9-10 | Final close, reporting |

### Close Checklist

- [ ] Bank reconciliations complete
- [ ] Revenue recognized correctly
- [ ] Expenses accrued
- [ ] Payroll posted
- [ ] Intercompany eliminated (if applicable)
- [ ] Balance sheet reconciled
- [ ] Variance analysis drafted

## Internal Controls

### Segregation of Duties

| Process | Separation |
|---------|------------|
| Payments | Approver ≠ Payer |
| Deposits | Receiver ≠ Recorder |
| Payroll | Processor ≠ Approver |
| Journal entries | Preparer ≠ Approver |

### Approval Thresholds

| Amount | Approver |
|--------|----------|
| < $1K | Manager |
| $1K - $10K | Director |
| $10K - $50K | VP |
| > $50K | CFO/CEO |

Adjust thresholds for company size.

## Financial Systems Stack

| Function | Options |
|----------|---------|
| Accounting | QuickBooks, Xero, NetSuite |
| Expense management | Brex, Ramp, Expensify |
| Billing | Stripe Billing, Chargebee |
| Payroll | Gusto, Rippling, ADP |
| FP&A | Excel, Mosaic, Pigment |
| Cap table | Carta, Pulley, Shareworks |

### Selection Criteria
- Current company size
- Growth trajectory
- Integration requirements
- Team capabilities
- Budget

## Building Finance Team

| Stage | Hire |
|-------|------|
| Pre-seed | Outsourced bookkeeper |
| Seed | Part-time controller or fractional CFO |
| Series A | Full-time controller |
| Series B | CFO, FP&A analyst |
| Series C+ | Treasury, tax, accounting manager |

## Audit Readiness

### When to Get Audited
- Required by investors (usually Series B+)
- Required by customers (enterprise sales)
- Preparing for acquisition
- Regulatory requirements

### Preparation
- Clean up historical books first
- Document accounting policies
- Organize supporting documentation
- Select auditor early (Big 4 vs regional)
- Budget 3-6 months for first audit

## Tax Considerations

### Key Items
- R&D tax credits (often overlooked)
- 409A valuations (required annually, before each round)
- Sales tax nexus (state by state)
- Transfer pricing (if international)
- Entity structure optimization

**Rule:** Get a startup-experienced tax advisor early.
