# Fundraising and Capital

## Fundraising Timing

| Signal | Action |
|--------|--------|
| 18+ months runway | Optional, opportunistic |
| 12-18 months | Start preparing |
| 6-12 months | Active fundraising |
| < 6 months | Emergency mode |

**Golden rule:** Raise when you can, not when you must.

## Data Room Preparation

Have ready before starting conversations:

### Required
- Financial statements (3 years or since inception)
- Monthly P&L and balance sheet
- Cap table (fully diluted)
- Bank statements (12 months)
- Revenue by customer (anonymized OK)
- Key contracts (customers, vendors)
- Employee roster with compensation

### Nice to Have
- Cohort analysis
- Unit economics breakdown
- Sales pipeline
- Product roadmap
- Competitive analysis

**Organize:** Clear folder structure, consistent naming, index document.

## Term Sheet Key Terms

| Term | What It Means | Negotiability |
|------|---------------|---------------|
| Valuation | Price per share, dilution | High |
| Liquidation preference | Who gets paid first in exit | Medium |
| Board seats | Control and governance | High |
| Anti-dilution | Protection if down round | Medium |
| Option pool | Dilution from employee equity | High |
| Pro-rata rights | Follow-on investment rights | Low |

### Red Flags
- > 1x participating preferred
- Full ratchet anti-dilution
- Excessive board control
- Unreasonable milestones tied to tranches

## Dilution Modeling

Before each round, model:
1. Current ownership %
2. New shares issued
3. Post-money ownership %
4. Future round assumptions
5. Exit scenarios

**Tool:** Cap table spreadsheet with scenario tabs.

## Investor Updates

Monthly, even when hard:

```
Subject: [Company] Monthly Update - [Month Year]

TL;DR: [One sentence state of company]

Key Metrics:
- MRR: $X (+Y% MoM)
- Customers: X (+Y)
- Runway: X months

Wins:
- [Achievement 1]
- [Achievement 2]

Challenges:
- [Challenge 1 with what you're doing about it]

Asks:
- [Specific intro or help needed]

Thanks,
[Name]
```

## Debt vs Equity Decision

| Factor | Favor Debt | Favor Equity |
|--------|------------|--------------|
| Cash flow | Predictable, positive | Variable, negative |
| Dilution tolerance | Low | Higher acceptable |
| Use of funds | Asset purchase | Growth investment |
| Risk tolerance | Lower | Higher |
| Timeline | Short-term need | Long-term runway |
