# Cash and Treasury Management

## 13-Week Cash Flow Forecast

The most critical financial tool. Update weekly.

| Week | Beginning Cash | Inflows | Outflows | Ending Cash |
|------|----------------|---------|----------|-------------|
| 1 | $500K | $100K | $80K | $520K |
| 2 | $520K | $50K | $120K | $450K |
| ... | ... | ... | ... | ... |

### Inflows to Track
- Customer payments (by expected date)
- Investor funding
- Credit line draws
- Tax refunds
- Other receivables

### Outflows to Track
- Payroll (largest, most predictable)
- Rent and facilities
- Vendor payments
- Debt service
- Tax payments
- One-time expenses

## Working Capital Optimization

### Accounts Receivable (Collect Faster)

| Tactic | Impact |
|--------|--------|
| Invoice immediately | Days saved |
| Offer early payment discount | 1-2% for 10 days faster |
| Automated reminders | Reduces late payments |
| Credit checks on new customers | Prevents bad debt |
| Annual prepay incentive | Cash upfront |

### Accounts Payable (Pay Strategically)

| Tactic | Consideration |
|--------|---------------|
| Use full payment terms | Don't pay early unnecessarily |
| Negotiate extended terms | 30→45→60 days |
| Early payment discounts | Take if > cost of capital |
| Vendor prioritization | Protect critical suppliers |

## Runway Calculation

```
Runway (months) = Cash / Monthly Burn Rate
```

**Warning thresholds:**
- < 6 months: Crisis mode, immediate action
- 6-12 months: Start fundraising or cut costs
- 12-18 months: Healthy, plan next round
- 18+ months: Strong position

## Credit Facilities

### Types

| Type | Use | Cost |
|------|-----|------|
| Revolver | Working capital smoothing | Interest + unused fee |
| Term loan | Asset purchase | Fixed payments |
| Venture debt | Extend runway | Interest + warrants |
| AR factoring | Immediate cash for receivables | Discount to face value |

### When to Secure

- When you don't need it (banks lend to healthy companies)
- Before large expenses are known
- With clean financials (easier approval)

**Never:** When desperate (terms will be terrible)

## Cash Flow Patterns

### Subscription Business
- Predictable monthly inflows
- Watch for churn impact
- Annual prepay improves cash cycle

### Transactional Business
- Lumpy revenue
- Higher cash buffer needed
- Seasonality planning critical

### Marketplace
- Float between collection and payout
- Can be cash positive even if unprofitable
- Watch payment processor holdbacks
