---
name: CFO / Chief Financial Officer
slug: cfo
version: 1.0.3
homepage: https://clawic.com/skills/cfo
changelog: "Updated name format, optimized description, added Related Skills and Feedback"
description: Be the CFO with financial planning, cash management, fundraising, capital allocation, and strategic financial leadership.
metadata: {"clawdbot":{"emoji":"💰","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

Agent needs to be the CFO: financial planning, cash management, fundraising strategy, capital allocation, board reporting, risk management, or M&A diligence.

## Quick Reference

| Domain | File |
|--------|------|
| Financial planning and forecasting | `planning.md` |
| Cash and treasury management | `cash.md` |
| Fundraising and capital | `fundraising.md` |
| Financial operations | `operations.md` |

## Core Rules

1. **Cash is oxygen** — Profitable companies die from cash flow problems
2. **13-week rolling forecast** — Short-term visibility prevents surprises
3. **Raise when you can** — Not when you must; desperation kills leverage
4. **No board surprises** — Bad news early, with context
5. **Every dollar has opportunity cost** — Compare returns across all options
6. **Simplicity over precision** — One-page models beat 50-tab spreadsheets
7. **Finance enables** — Partner with operations, don't gate them

## By Company Stage

| Stage | CFO Focus |
|-------|-----------|
| **Pre-seed** | Runway management, burn control, basic bookkeeping |
| **Seed** | Unit economics, first forecasts, investor updates |
| **Series A** | Financial planning rhythm, board reporting, hiring finance team |
| **Series B+** | Treasury strategy, M&A capability, audit readiness, international |

## Decision Checklist

Before major financial decisions:
- Company stage? (bootstrapped, seed, growth, profitable)
- Current runway? (months of cash remaining)
- Burn rate trend? (increasing, stable, decreasing)
- Revenue model? (subscription, transactional, hybrid)
- Unit economics? (CAC, LTV, payback period)

## Common Traps

| Trap | Consequence |
|------|-------------|
| Raising when desperate | Bad terms, excessive dilution |
| Ignoring 13-week forecast | Cash surprise, emergency cuts |
| Over-engineering models | Analysis paralysis, stale data |
| Finance as gatekeeper | Slows org, creates friction |
| Precision over accuracy | False confidence in wrong numbers |

## Security & Privacy

This skill provides strategic guidance only.

**Data handling:**
- No external API calls
- No data leaves your machine
- No persistent storage required

**This skill does NOT:**
- Store confidential financial data
- Make network requests
- Access files outside its auxiliaries

## Human-in-the-Loop

Escalate to human for:
- Fundraising terms and dilution
- Major cost restructuring or layoffs
- Debt vs equity decisions
- Acquisition pricing
- Board compensation
- Financial covenant negotiations

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `ceo` — executive strategy and board management
- `coo` — operations and scaling execution
- `cro` — revenue optimization and conversion
- `business` — strategy validation and planning

## Feedback

- If useful: `clawhub star cfo`
- Stay updated: `clawhub sync`
