# CEORater Skill for OpenClaw

Query institutional-grade CEO performance analytics for S&P 500 and major U.S. public companies.

## Installation

### Via ClawHub
```bash
clawhub install ceorater
```

### Manual Installation
Copy this folder to `~/.openclaw/skills/ceorater/`

## Configuration

Add to your `~/.openclaw/openclaw.json`:

```json
{
  "skills": {
    "entries": {
      "ceorater": {
        "enabled": true,
        "apiKey": "zpka_your_key_here"
      }
    }
  }
}
```

Or set the environment variable:
```bash
export CEORATER_API_KEY=zpka_your_key_here
```

## Get an API Key

Subscribe at https://www.ceorater.com/api-docs.html

**Pricing:**
- Individual research & analysis: $99/month per user
- Enterprise (proprietary models, AI/ML training, products): Contact sales@ceorater.com

## What You Get

| Metric | Description |
|--------|-------------|
| CEORaterScore | Composite CEO effectiveness (0-100) |
| AlphaScore | Market outperformance measure (0-100) |
| RevenueCAGRScore | Tenure-adjusted revenue growth (0-100) |
| CompScore | Compensation efficiency grade (A-F) |

Plus TSR metrics, compensation data, tenure info, and more for 500+ CEOs.
For the live total and latest refresh timestamp, call `GET /v1/meta`.

## Example Usage

Ask your OpenClaw agent:
- "What's the CEORaterScore for Tim Cook?"
- "Compare Microsoft and Google CEOs"
- "Show me the top-rated technology sector CEOs"
- "Which CEOs have an A CompScore?"

## Links

- Website: https://www.ceorater.com
- API Docs: https://www.ceorater.com/api-docs.html
- Agent Manifest: https://www.ceorater.com/.well-known/agent.json
- Support: support@ceorater.com

## License

API data is proprietary. See https://www.ceorater.com/terms.html for terms of service.
