# Strategy and Vision

## Strategy Definition

Strategy is choosing what NOT to do. With infinite opportunities and finite resources, clarity comes from exclusion.

**Good strategy has:**
- Clear diagnosis of the challenge
- Guiding policy (overall approach)
- Coherent actions that implement the policy

**Bad strategy is:**
- Vague goals disguised as strategy
- Lists of initiatives without prioritization
- Avoiding the hard trade-offs

## Strategic Planning Frameworks

### 1. Where to Play / How to Win

| Question | What to Define |
|----------|----------------|
| Where to play | Markets, segments, geographies, channels |
| How to win | Differentiation, cost advantage, network effects |
| Capabilities needed | What must we be great at? |
| Management systems | Processes to maintain advantage |

### 2. Jobs to Be Done

Don't ask what customers want. Ask what job they're hiring your product to do.

- Functional job (complete a task)
- Emotional job (feel a certain way)
- Social job (be perceived by others)

### 3. Competitive Moats

| Moat Type | Example | Durability |
|-----------|---------|------------|
| Network effects | Marketplace, social | High |
| Switching costs | Enterprise SaaS | High |
| Scale economies | Manufacturing | Medium |
| Brand | Consumer goods | Medium |
| Patents | Pharma | Time-limited |
| Regulatory | Banking | Location-specific |

## Vision Communication

Vision should be:
- **Memorable** — One sentence that sticks
- **Ambitious** — Inspires but isn't fantasy
- **Clear** — No corporate jargon
- **Stable** — Changes rarely (strategy changes more often)

**Template:** "We [action] for [audience] so they can [outcome]"

## Annual Planning Rhythm

| Month | Activity |
|-------|----------|
| Q3 | Strategy review, multi-year direction |
| Q4 Oct | Team inputs, bottom-up planning |
| Q4 Nov | Leadership alignment, trade-offs |
| Q4 Dec | Board approval, company communication |
| Q1 | Execute, measure, adjust |

## Strategy Review Questions

Quarterly, ask:
1. What assumptions have changed since last quarter?
2. Which strategic bets are working/not working?
3. Where are competitors moving?
4. What customer needs are we missing?
5. Do we need to adjust or stay the course?
