# People and Culture

## CEO Time Allocation

50% of CEO time goes to people. This is not overhead — it IS the job.

| Activity | Cadence | Purpose |
|----------|---------|---------|
| 1:1s with directs | Weekly | Alignment, coaching, blockers |
| Skip levels | Monthly | Ground truth, culture pulse |
| Recruiting | 20% of time | Pipeline never stops |
| Culture work | Ongoing | Modeling, reinforcing, correcting |

## Culture Definition

Culture is not what you say. It's what you tolerate, reward, and punish.

**Culture levers:**
- Who you hire (values filter)
- Who you fire (values enforcement)
- Who you promote (values reward)
- What you celebrate (values visibility)
- What you ignore (values erosion)

### Culture Debt

Like technical debt, culture debt compounds:
- One bad hire tolerated → team learns you don't mean it
- One missed value → threshold lowers
- Clean it fast or pay exponentially later

## Hiring Framework

### Scorecard Method

Before searching, define:
1. **Mission** — Why this role exists
2. **Outcomes** — 3-5 measurable results in first year
3. **Competencies** — Skills and behaviors needed
4. **Culture fit** — Which values this role must embody

### Interview Structure

| Stage | Focus | Who |
|-------|-------|-----|
| Screen | Competency basics, motivation | Recruiter |
| Deep dive | Past performance, specifics | Hiring manager |
| Culture | Values alignment, work style | Cross-functional |
| Reference | Verify claims, uncover risks | Hiring manager |
| Close | Sell opportunity, negotiate | CEO (for execs) |

### Reference Calls

Never skip. Always call people NOT on their list.

**Questions that reveal:**
- "If you were hiring for X role, would you hire this person?" (direct)
- "What would their peers say about working with them?" (team fit)
- "Where did they struggle?" (growth areas)
- "Would you work with them again?" (ultimate test)

## Performance Management

### Continuous Feedback

Annual reviews are too late. Weekly calibration prevents surprises.

**1:1 structure:**
1. What's working? (2 min)
2. What's blocked? (5 min)
3. Where do you need help? (5 min)
4. Feedback from me (3 min)
5. Anything else? (5 min)

### Performance Categories

| Category | % of Team | Action |
|----------|-----------|--------|
| Top performers | 10-20% | Stretch, retain, reward |
| Strong performers | 60-70% | Develop, coach, clear path |
| Underperformers | 10-20% | PIP or exit, don't wait |

### Managing Out

When to act:
- Pattern of misses, not one bad quarter
- Values violation, regardless of performance
- Role outgrew person, despite effort
- Trust broken

How to act:
- Decide, then act fast — lingering destroys morale
- Generous terms, clean exit
- Protect their dignity publicly
- Learn and adjust hiring criteria

## Compensation Philosophy

### Principles

1. **Pay market or above** — Cheap hires are expensive mistakes
2. **Internal equity matters** — Resentment kills teams
3. **Equity is alignment** — Skin in the game
4. **Transparency builds trust** — Explain the system

### Equity Guidelines

| Stage | Exec | Senior IC | IC |
|-------|------|-----------|-----|
| Seed | 1-2% | 0.25-0.5% | 0.05-0.1% |
| Series A | 0.5-1% | 0.1-0.25% | 0.01-0.05% |
| Series B+ | 0.1-0.5% | 0.025-0.1% | 0.005-0.025% |

*Ranges vary by role criticality and candidate strength.*

## Organizational Design

### Spans and Layers

- Ideal span: 5-8 direct reports
- More layers = slower communication
- Fewer layers = overwhelmed managers

### When to Add a Layer

| Signal | Meaning |
|--------|---------|
| Manager has 10+ directs | Span too wide |
| Decisions take weeks | Communication bottleneck |
| Manager in meetings all day | No time for work |
| Team morale dropping | People feel unseen |

### Reorgs

Reorg when:
- Strategy changed and org doesn't match
- Clear bottleneck everyone feels
- Growth forced it (doubled headcount)

Never reorg to:
- Avoid a hard conversation
- Accommodate one person
- Look busy

## Executive Team Dynamics

### Signs of Healthy Exec Team

- Debate ideas fiercely, commit fully
- Solve problems together, not in silos
- Call out each other's blind spots
- Put company above function
- Laugh together sometimes

### Signs of Dysfunction

- Side conversations after meetings
- Blame other teams for misses
- CEO as tiebreaker for everything
- Silence in meetings, politics outside
- Competing for CEO attention

### Building Trust

- Quarterly offsite (no laptops, real talk)
- Vulnerability from the top
- Shared wins and losses
- No favorites, no backchannels
