# Fundraising

## When to Raise

| Signal | Meaning |
|--------|---------|
| 12-18 months runway | Start conversations |
| Clear milestone ahead | Best time to raise |
| Market hot | Opportunistic, even if not needed |
| Market cold | Raise fast if you can, or cut |

**Never raise:**
- When desperate (bad terms, wrong partners)
- Without clear use of funds
- Before knowing your metrics cold

## Fundraising Timeline

| Phase | Duration | Activities |
|-------|----------|------------|
| Prep | 4-8 weeks | Materials, target list, warm intros |
| Process | 6-12 weeks | Meetings, diligence, term sheets |
| Close | 4-6 weeks | Legal, wiring, announce |

**Total:** 3-6 months. Start early.

## Materials Needed

### Deck (10-15 slides)

| Slide | Purpose | Time |
|-------|---------|------|
| Title/Hook | One sentence, memorable | 30s |
| Problem | Pain point, who has it | 1 min |
| Solution | Your product/service | 1 min |
| Traction | Metrics, growth, retention | 2 min |
| Market | TAM/SAM/SOM, why now | 1 min |
| Business model | How you make money | 1 min |
| Competition | Positioning, moat | 1 min |
| Go-to-market | How you acquire customers | 1 min |
| Team | Why you'll win | 1 min |
| Financials | Projections, unit economics | 1 min |
| Ask | Amount, use of funds | 30s |

### Data Room

- Financial model (3-year projection)
- Cap table
- Key contracts
- Team bios
- Product roadmap
- Customer references
- Legal (incorporation, IP assignment)

## Investor Targeting

### Fit Matters

| Criteria | Why |
|----------|-----|
| Stage match | Seed funds don't lead Series B |
| Sector focus | Domain expertise helps |
| Check size | Match your round size |
| Value-add | Board seats, network, expertise |
| Reputation | Talk to portfolio founders |

### Building the List

1. Research: Crunchbase, portfolios, recent deals
2. Prioritize: Tier 1 (dream partners), Tier 2 (strong), Tier 3 (backup)
3. Warm intros: Portfolio founders, mutual connections
4. Cold outreach: Only if no warm path exists

## Running the Process

### Create Competition

- Never go exclusive until term sheet
- Multiple meetings in same weeks
- Create (real) urgency with timeline
- "We're seeing other investors this week"

### Meeting Cadence

| Stage | Format | Decision |
|-------|--------|----------|
| Intro | 30 min | Partner interest? |
| Deep dive | 60 min | Technical/market fit? |
| Partnership | 60 min | Full partnership vote |
| Term sheet | Days | Review and negotiate |

### Follow-up

- Same day: Thank you, next steps, any materials needed
- Within 48h: Any questions from the meeting
- Weekly: Progress updates, traction news
- If no: Ask for feedback, referrals

## Term Sheet Negotiation

### Key Terms

| Term | What to Watch |
|------|---------------|
| Valuation | Pre vs post money |
| Liquidation preference | 1x non-participating = standard |
| Board seats | Founder control at early stages |
| Option pool | Pre-money = dilutes existing shareholders |
| Pro-rata rights | Investor can maintain ownership |
| Anti-dilution | Weighted average = standard |
| Vesting | 4 years, 1 year cliff = standard |

### What to Negotiate

1. **Valuation** — Know your range from comparables
2. **Board composition** — Maintain control early
3. **Option pool size** — Post-money if possible
4. **Protective provisions** — Limit what requires approval

### What to Accept

- 1x non-participating preference (standard)
- Information rights (reasonable)
- Right of first refusal (normal)
- Standard drag-along

## Closing

### From Term Sheet to Wire

1. Sign term sheet (becomes exclusive)
2. Confirmatory diligence (2-3 weeks)
3. Legal docs drafted (1-2 weeks)
4. Negotiate final docs (1 week)
5. Sign and wire (days)

### Don't Celebrate Until Wired

Deals die at every stage. Until money is in the bank:
- Keep other conversations warm
- Don't announce publicly
- Don't commit the spend
- Stay paranoid

## Post-Close

### Immediate

- Thank investors personally
- Update cap table
- Set board meeting cadence
- Plan announcement (if desired)

### Ongoing

- Monthly investor updates (always)
- Use them actively (intros, advice)
- No surprises — bad news travels fast
- Build relationship for next round

## Bridge Rounds

### When Appropriate

- Clear milestone within 6-12 months
- Existing investors supportive
- Not just delaying inevitable

### Typical Terms

- Convertible note or SAFE
- Often at discount to next round (15-20%)
- Sometimes with valuation cap
- Keep it simple, move fast

### Warning Signs

- Bridge to bridge to bridge
- No milestone defined
- Existing investors declining
- "We just need 3 more months"
