# Financial Scenarios and Modeling

## Runway Calculator

```
Runway (months) = Cash Balance / Monthly Burn Rate
```

### Burn Rate Types

| Type | Definition | Use Case |
|------|------------|----------|
| Gross burn | Total monthly expenses | Worst case planning |
| Net burn | Expenses - Revenue | Normal planning |
| Adjusted burn | Net burn with planned changes | Scenario modeling |

### Runway Zones

| Runway | Status | Action |
|--------|--------|--------|
| 18+ months | Comfortable | Execute strategy |
| 12-18 months | Start fundraising | Begin investor conversations |
| 6-12 months | Urgent | Actively close round OR cut costs |
| < 6 months | Crisis | Emergency measures, bridge round |

## Scenario Planning Framework

Build three scenarios for any major decision:

| Scenario | Assumptions | Outcome |
|----------|-------------|---------|
| **Base** | Current trajectory continues | Expected result |
| **Bull** | Key metrics improve 20-30% | Upside potential |
| **Bear** | Key metrics decline 20-30% | Downside risk |

### Variables to Model

- Revenue growth rate
- Churn/retention
- CAC and payback period
- Hiring pace
- Unit economics
- Market conditions

## Unit Economics Template

| Metric | Formula | Target |
|--------|---------|--------|
| CAC | Total acquisition cost / New customers | < LTV/3 |
| LTV | ARPU × Gross margin × Avg lifespan | > 3× CAC |
| Payback | CAC / (ARPU × Gross margin) | < 12 months |
| Gross margin | (Revenue - COGS) / Revenue | > 70% SaaS |
| Magic number | Net new ARR / S&M spend | > 0.75 |

## Cash Flow Projections

**Monthly model should include:**

| Line | Description |
|------|-------------|
| Starting cash | Previous month ending |
| Revenue | Collections, not bookings |
| COGS | Direct costs of delivery |
| Gross profit | Revenue - COGS |
| OpEx | R&D, S&M, G&A |
| Net burn | Gross profit - OpEx |
| Ending cash | Starting - Net burn |

## Valuation Basics

### Revenue Multiples by Stage

| Stage | Typical Multiple | Factors |
|-------|------------------|---------|
| Seed | 10-20× ARR | Team, TAM, vision |
| Series A | 8-15× ARR | Growth rate, retention |
| Series B | 6-12× ARR | Unit economics, moat |
| Series C+ | 5-10× ARR | Profitability path |

*Multiples vary by market conditions, sector, and growth rate.*

### Valuation Drivers

1. **Growth rate** — Higher growth = higher multiple
2. **Retention** — Net dollar retention > 100% = expansion
3. **TAM** — Bigger market = bigger opportunity
4. **Gross margin** — SaaS > 70%, marketplace 40-60%
5. **Efficiency** — Rule of 40 (growth + margin > 40%)

## Budget Planning

### Zero-Based Budgeting

Don't assume last year's budget is baseline. Justify every expense from zero.

**Process:**
1. List all activities and their costs
2. Rank by impact on company goals
3. Allocate budget top-down until depleted
4. Cut everything below the line

### Headcount Planning

| Role Type | Planning Horizon | Flexibility |
|-----------|------------------|-------------|
| Leadership | 12+ months | Low - hire slow |
| Core team | 6-12 months | Medium |
| Contractors | 0-3 months | High |

## Financial Governance

### Monthly Review

- P&L vs budget variance
- Cash position and runway
- Key metrics vs plan
- Expense approval queue

### Quarterly Review

- Reforecast for remaining year
- Adjust hiring plans
- Board financial update
- Scenario planning refresh

## Crisis Financial Playbook

### When Cash is Tight

| Lever | Speed | Impact |
|-------|-------|--------|
| Freeze hiring | Immediate | Low |
| Reduce marketing | 30 days | Medium |
| Renegotiate contracts | 60 days | Medium |
| Layoffs | 30 days | High |
| Pivot/shutdown products | 90 days | High |

### Bridge Round Considerations

- Term should match time to milestone
- Existing investors first
- Valuation: often flat or down
- Don't bridge to nowhere - have a plan
