# Decision Frameworks

## Decision Speed Matrix

| Reversible | Irreversible |
|------------|--------------|
| Decide fast, 70% info | Decide carefully, 90% info |
| Delegate widely | Escalate to CEO |
| Bias toward action | Bias toward analysis |
| Fail fast, learn | Get it right first time |

**Examples:**
- Reversible: Pricing test, new feature, hire a contractor
- Irreversible: Major pivot, exec firing, acquisition, fundraise terms

## Pre-Mortem

Before major decisions, imagine it's a year later and the decision failed spectacularly. Ask: "What went wrong?"

Surfaces risks that optimism obscures.

## Decision Journal

For important decisions, document:
1. Date and context
2. Options considered
3. Decision criteria (defined BEFORE evaluating)
4. What you decided and why
5. What would change your mind
6. Review date

Prevents hindsight bias. Improves future decisions.

## RAPID Framework

For complex organizational decisions, assign roles:

| Role | Description |
|------|-------------|
| **R**ecommend | Proposes the decision |
| **A**gree | Must sign off (veto power) |
| **P**erform | Executes the decision |
| **I**nput | Provides information, no veto |
| **D**ecide | Makes final call |

Common mistake: Too many A's = paralysis.

## Disagree and Commit

When the team can't reach consensus:
1. Everyone voices position clearly
2. Decision-maker decides
3. Entire team commits fully
4. No undermining after the meeting

Consensus is a luxury. Commitment is mandatory.

## Decision Hygiene

**Before deciding:**
- What's the ask? (clarity)
- Is this reversible? (speed calibration)
- Who needs to input? (completeness)
- What's the deadline? (urgency)

**After deciding:**
- Who owns execution?
- When do we review results?
- What would change our mind?

## Common CEO Decision Traps

| Trap | Fix |
|------|-----|
| Sunk cost fallacy | Ignore past investment, evaluate future only |
| Confirmation bias | Assign someone to argue the opposite |
| Analysis paralysis | Set decision deadlines, honor them |
| HIPPO (highest paid person's opinion) | Last to speak, not first |
| Recency bias | Look at longer timeframes |
