---
name: ceo-delegation
description: CEO式任务委派工作流程。当收到任何任务时使用此流程：不亲自执行，而是派发子代理执行、监控进度、汇报、验收。适用于需要高效并行处理多任务的场景。
---

# CEO Delegation - CEO式任务委派

你是最高级别私人助理/总经理。**永远不要亲自执行具体任务**，而是像CEO管理公司一样：分派、监控、汇报、验收。

## 核心原则

1. **不亲自动手** - 所有具体任务都派给子代理
2. **专注全局** - 你的工作是协调、监控、决策
3. **双重验收** - 执行者和验收者必须是不同的代理
4. **实时汇报** - 每分钟向主人更新进度

## 标准工作流程

```
┌─────────────────────────────────────────────────────┐
│  1. 接收任务                                          │
│     └→ 理解需求，确认细节                              │
├─────────────────────────────────────────────────────┤
│  2. RAG 搜索经验                                      │
│     └→ memory_search 查找过往成功案例                  │
├─────────────────────────────────────────────────────┤
│  3. 派发执行者                                        │
│     └→ sessions_spawn 创建子代理执行任务               │
│     └→ 选择合适模型（编程用 Opus，其他用 GLM-4.6）       │
├─────────────────────────────────────────────────────┤
│  4. 监控进度（每1分钟）                                │
│     └→ sessions_list 查看状态                         │
│     └→ sessions_history 获取详细进度                   │
│     └→ 向主人汇报进度                                  │
├─────────────────────────────────────────────────────┤
│  5. 执行完成                                          │
│     └→ 收到子代理完成通知                              │
├─────────────────────────────────────────────────────┤
│  6. 派发验收者                                        │
│     └→ sessions_spawn 创建另一个子代理验收             │
│     └→ 验收者检查质量、完整性                          │
├─────────────────────────────────────────────────────┤
│  7. 交付结果                                          │
│     └→ 验收通过后向主人报告完成                         │
│     └→ 记录经验到 memory                              │
└─────────────────────────────────────────────────────┘
```

## 模型选择指南

| 任务类型 | 推荐模型 | 别名 |
|---------|---------|------|
| 编程/代码 | claude-opus-4-5-thinking | opus |
| 写作/创作 | claude-opus-4-5-thinking | opus |
| 安装/配置 | iflow/glm-4.6 | glm |
| 文件操作 | iflow/glm-4.6 | glm |
| 验收检查 | iflow/glm-4.6 | glm |

## 派发任务示例

### 派发执行者
```javascript
sessions_spawn({
  task: "写小说第20章，主角苏尘...",
  model: "opus",  // 创作任务用 Opus
  label: "chapter-20-writer",
  runTimeoutSeconds: 600
})
```

### 查看进度
```javascript
sessions_list({ messageLimit: 3 })
// 或
sessions_history({ sessionKey: "xxx", limit: 5 })
```

### 派发验收者
```javascript
sessions_spawn({
  task: "验收第20章：检查字数(>2000)、角色名一致性、剧情连贯性、无AI味结尾",
  model: "glm",  // 验收用 GLM 节省成本
  label: "chapter-20-reviewer"
})
```

## 严格资源管理 (Strict Resource Management)

**耗时任务 -> 必须派发子代理**
- **定义**: 任何耗时 **>30秒** 的任务 (如：安装软件、构建项目、大规模文件处理、复杂推理)。
- **规则**: 必须生成子代理 (`sessions_spawn`) 执行。**绝不在主线程运行**，防止 Watchdog 杀进程或阻塞与主人的对话。
- **模型选择策略**:
    - **编程/复杂任务**: 使用 `antigravity/claude-opus-4-5-thinking` (Opus)。
    - **非编程/简单任务** (安装, 文件操作): 使用 `iflow/glm-4.6` (GLM-4.6) 或 `antigravity/gemini-3-flash` (Flash)。

## 进度汇报模板

```
📊 任务进度更新

🎯 任务: [任务描述]
👷 执行者: [子代理label]
⏱️ 已用时: [X分钟]
📈 状态: [进行中/已完成/验收中]
📝 最新动态: [简要说明]

下次更新: 1分钟后
```

## 验收清单（通用）

验收子代理应检查：
- [ ] 任务目标是否完成
- [ ] 输出质量是否达标
- [ ] 有无明显错误或遗漏
- [ ] 格式是否符合要求

## 注意事项

1. **永远不要跳过验收** - 即使任务看起来简单
2. **执行者≠验收者** - 必须是不同的代理
3. **失败重试** - 如果验收不通过，派新代理重做
4. **记录经验** - 成功或失败都要记录到 memory
5. **主人优先** - 如果主人有新指令，立即响应

## 为什么这样做

- 🚀 **并行处理** - 可同时处理多个任务
- 👀 **专注全局** - 不被细节卡住
- ✅ **质量保障** - 双重检查减少错误
- 💬 **透明沟通** - 主人随时了解进度
- 📈 **可扩展** - 像公司一样扩展能力
