# Guide SENACS — Système d'Échanges National des Centres Sociaux

## 1. Présentation générale

### 1.1 Qu'est-ce que SENACS ?

**SENACS** (Système d'Échanges National des Centres Sociaux) est une plateforme en ligne de collecte et de restitution de données sur les centres sociaux et espaces de vie sociale (EVS) agréés en France.

- **Site :** www.senacs.fr
- **Pilotage :** CNAF et FCSF (partenariat paritaire)
- **Lancement :** 2009
- **Population concernée :** tous les centres sociaux et EVS agréés par une Caf

### 1.2 Objectifs

1. **Donner à voir** l'action des centres sociaux et EVS à l'échelle locale, départementale, régionale et nationale
2. **Produire des analyses thématiques** (parentalité, jeunesse, participation, numérique, etc.)
3. **Produire des analyses territoriales** permettant de comparer et d'adapter les politiques
4. **Outiller le pilotage** des structures, des Caf et des fédérations
5. **Contribuer au plaidoyer** en faveur de l'animation de la vie sociale

---

## 2. Fonctionnement

### 2.1 Cycle annuel

| Période | Action |
|---|---|
| **Janvier-février** | Préparation de la campagne (mise à jour du questionnaire, formation des correspondants) |
| **Mars-avril** | Ouverture de la saisie en ligne sur senacs.fr |
| **Mai-juin** | Période principale de saisie par les centres sociaux et EVS |
| **Juin-juillet** | Clôture de la saisie, relances |
| **Juillet-septembre** | Contrôle de cohérence des données |
| **Septembre-décembre** | Traitement, analyses, production des plaquettes |
| **Décembre-janvier** | Diffusion des résultats |

### 2.2 Qui saisit ?

- **Le centre social ou l'EVS** saisit ses propres données (données déclaratives)
- Le directeur ou un membre de l'équipe désigné effectue la saisie
- Un identifiant et mot de passe sont attribués à chaque structure

### 2.3 Nature des données

Les données saisies sont **déclaratives** : c'est la structure elle-même qui renseigne ses informations. Elles portent sur l'année civile précédente (N-1).

**Principes :**
- **Anonymat** : aucune donnée nominative individuelle
- **Agrégation** : les restitutions sont toujours agrégées (pas de données par structure identifiable publiquement)
- **Volontariat éclairé** : la saisie est attendue par la Caf dans le cadre de l'agrément

---

## 3. Contenu du questionnaire SENACS

### 3.1 Rubriques principales

#### A. Identification et territoire
- Nom, adresse, statut juridique
- Territoire d'intervention (commune, quartier, intercommunalité)
- Quartier prioritaire politique de la ville (QPV) : oui/non
- Caractéristiques du territoire (urbain, périurbain, rural)

#### B. Gouvernance
- Nature de la gestion (associative, municipale, CCAS, etc.)
- Nombre d'administrateurs
- Fréquence des CA et AG
- Instances participatives (comités d'usagers, commissions thématiques)
- Présence de commissions ou groupes de travail avec des habitants

#### C. Ressources humaines
- **Salariés** : nombre, ETP, catégories (direction, animation, administratif, technique)
- **Bénévoles** : nombre, heures estimées, rôles
- **Services civiques** : nombre
- **Stagiaires** : nombre
- Directeur : qualification, ancienneté
- Référent familles : ETP, qualification

#### D. Budget et financements
- Budget total de fonctionnement
- Répartition par financeur :
  - Caf (PS + dotation action sociale)
  - Commune / EPCI
  - Département
  - État
  - Autres (région, Europe, fondations, recettes propres)
- Part de chaque financeur dans le budget total
- Budget d'investissement

#### E. Accueil et publics
- Jours et horaires d'ouverture
- Nombre de passages à l'accueil
- Nombre d'usagers uniques (adhérents ou inscrits)
- Profil des usagers :
  - Tranches d'âge
  - Répartition H/F
  - Quotient familial (par tranche)
  - Quartier de résidence

#### F. Activités et services
- Par secteur : enfance, jeunesse, famille, adultes, seniors
- Type d'activités : régulières, ponctuelles, projets
- Activités spécifiques :
  - ALSH (nombre de places, jours d'ouverture)
  - CLAS (nombre d'enfants accompagnés)
  - ASL (nombre de participants)
  - LAEP (fréquentation)
  - Actions parentalité
  - Actions numériques
  - Actions insertion
  - Actions santé

#### G. Participation des habitants
- Nombre de bénévoles actifs dans la gouvernance
- Nombre de bénévoles actifs dans les activités
- Instances participatives (type, fréquence, nombre de participants)
- Projets co-construits avec les habitants

#### H. Partenariats
- Nombre et nature des partenaires
- Conventions formalisées
- Participation à des réseaux ou coordinations

---

## 4. Organisation et acteurs

### 4.1 Correspondants SENACS

Chaque département dispose de **deux correspondants SENACS** :

| Correspondant | Rattachement | Rôle |
|---|---|---|
| **Correspondant Caf** | Caf locale | Accompagne la saisie, relance les centres, vérifie la cohérence des données côté institutionnel |
| **Correspondant fédéral** | Fédération départementale | Accompagne les centres fédérés, favorise la mobilisation, anime les restitutions |

### 4.2 Comité de pilotage départemental

- Réunit les correspondants Caf et fédéraux + direction Caf
- Se réunit 2 à 3 fois par an
- **Missions :**
  - Piloter la campagne de saisie départementale
  - Contrôler la cohérence des données
  - Produire la plaquette départementale
  - Organiser la restitution aux centres sociaux
  - Identifier les analyses thématiques locales

### 4.3 Pilotage national

- **CNAF** : pilotage technique, hébergement de la plateforme, traitement statistique
- **FCSF** : mobilisation du réseau, valorisation des résultats, communication
- **Comité de pilotage national** : orientations stratégiques, évolutions du questionnaire

---

## 5. Contrôle de cohérence

### 5.1 Processus

Après la saisie, les données font l'objet d'un **contrôle de cohérence** :

1. **Contrôles automatiques** : la plateforme détecte les incohérences flagrantes (ex : budget négatif, ETP > salariés)
2. **Contrôle par les correspondants** : vérification manuelle des données atypiques
3. **Retour aux centres** : demande de correction si nécessaire
4. **Validation** : les données sont validées après corrections

### 5.2 Points de vigilance courants

- Cohérence entre nombre de salariés et ETP
- Cohérence entre budget total et détail par financeur
- Nombre d'usagers vs. capacité d'accueil
- Données manquantes (rubriques non renseignées)
- Évolutions importantes d'une année sur l'autre (à justifier)

---

## 6. Restitution et communication

### 6.1 Plaquettes de communication

| Niveau | Contenu | Production |
|---|---|---|
| **Nationale** | Panorama des centres sociaux en France | CNAF + FCSF |
| **Régionale** | Données agrégées par région | Unions régionales |
| **Départementale** | Portrait des centres sociaux du département | Comité de pilotage départemental |
| **Locale** | Données d'un centre ou d'un territoire (si accord) | Centre social + correspondants |

### 6.2 Accès aux données

- **Site senacs.fr** : données publiques agrégées, cartes interactives
- **Plaquettes PDF** : téléchargeables sur le site
- **Données brutes** : accessibles aux Caf et fédérations pour analyses approfondies (pas publiques)

### 6.3 Charte d'utilisation SENACS

La charte d'utilisation encadre :
- La **confidentialité** des données individuelles
- Les **conditions de diffusion** des résultats
- Le **droit de regard** des structures sur l'utilisation de leurs données
- L'**interdiction** d'utiliser les données à des fins de contrôle individuel
- L'engagement de **restitution** aux structures contributrices

---

## 7. Conseils pratiques pour la saisie

### 7.1 Préparation

Avant d'ouvrir la plateforme, rassembler :
- [ ] Rapport d'activité de l'année N-1
- [ ] Bilan financier N-1 (compte de résultat détaillé)
- [ ] Tableau des effectifs salariés (ETP par catégorie)
- [ ] Liste des bénévoles actifs
- [ ] Statistiques de fréquentation par secteur
- [ ] Données sur les usagers (si collectées : âge, QF, quartier)
- [ ] Liste des partenariats et conventions
- [ ] Données ALSH, CLAS, ASL, LAEP (si applicable)

### 7.2 Bonnes pratiques

1. **Désigner un responsable** de la saisie (et un suppléant)
2. **Ne pas attendre le dernier moment** : la saisie prend 2-4 heures
3. **Utiliser les données du rapport d'activité** comme base
4. **En cas de doute**, contacter le correspondant SENACS Caf ou fédéral
5. **Conserver une copie** des données saisies (export PDF ou capture)
6. **Vérifier la cohérence** avant de valider
7. **Comparer avec N-1** : les écarts importants seront questionnés

### 7.3 Erreurs fréquentes

| Erreur | Correction |
|---|---|
| Confondre nombre de salariés et nombre d'ETP | Salariés = personnes physiques ; ETP = volume de travail |
| Oublier les bénévoles occasionnels | Compter tous ceux qui ont contribué dans l'année |
| Ne pas inclure les recettes propres dans le budget | Cotisations, participations familles = recettes propres |
| Comptabiliser les mêmes usagers dans plusieurs secteurs | Un usager unique = 1, même s'il fréquente plusieurs secteurs |
| Ne pas renseigner les rubriques « non concerné » | Indiquer 0 plutôt que laisser vide |
