# Référentiel d'indicateurs de pilotage — Centre Social

---

## 1. Indicateurs de fréquentation

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Nombre total d'usagers | Personnes différentes ayant fréquenté le centre sur la période | Fichier adhérents / logiciel | Annuel |
| Nombre d'adhérents | Personnes ayant pris une adhésion | Fichier adhérents | Annuel |
| Taux de renouvellement | % d'adhérents renouvelés d'une année sur l'autre | Fichier adhérents | Annuel |
| Nouveaux usagers | Nombre de personnes fréquentant pour la 1ère fois | Fichier adhérents | Annuel |
| Fréquentation par secteur | Nb usagers par secteur (enfance, jeunesse, famille, adultes) | Pointage activités | Mensuel |
| Journées-enfants (ALSH) | Nb d'enfants × nb de jours de présence | Pointage ALSH | Par période |
| Taux d'occupation (ALSH) | Nb inscrits / capacité d'accueil autorisée | Pointage ALSH | Hebdo |
| Fréquentation accueil libre | Nombre de passages à l'accueil | Comptage | Mensuel |

---

## 2. Indicateurs de mixité sociale

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Répartition par QF | % d'usagers par tranche de quotient familial | Fichier adhérents + CAF | Annuel |
| % usagers QPV | Part des usagers résidant en quartier prioritaire | Adresse + zonage | Annuel |
| Répartition par âge | Pyramide des âges des usagers | Fichier adhérents | Annuel |
| Répartition H/F | % hommes / femmes parmi les usagers | Fichier adhérents | Annuel |
| Familles monoparentales | % de familles monoparentales parmi les familles inscrites | Fichier adhérents | Annuel |
| Taux de couverture territoriale | % de la population du territoire touchée | Fichier + données INSEE | Annuel |

---

## 3. Indicateurs de participation des habitants

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Nombre de bénévoles actifs | Bénévoles ayant participé à au moins 1 action | Fichier bénévoles | Annuel |
| Heures de bénévolat | Total heures de bénévolat estimées | Fichier bénévoles | Annuel |
| Valorisation du bénévolat | Valeur en € (barème CNAF ou SMIC) | Calcul | Annuel |
| Projets portés par habitants | Nb de projets initiés par des habitants | Suivi projets | Annuel |
| Participation aux instances | Nb moyen de participants aux instances (CA, comités, AG) | PV réunions | Par réunion |
| Taux de participation AG | Nb présents+pouvoirs / nb adhérents | PV AG | Annuel |
| Nb d'habitants dans la gouvernance | Habitants non-professionnels dans le CA | Liste CA | Annuel |

---

## 4. Indicateurs d'activité

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Nombre d'activités proposées | Total d'activités régulières + ponctuelles | Planning | Annuel |
| Nombre de séances réalisées | Total des séances toutes activités | Pointage | Mensuel |
| Taux de remplissage activités | Nb inscrits / capacité par activité | Pointage | Trimestriel |
| Nombre d'événements | Manifestations, fêtes, sorties, forums | Calendrier | Annuel |
| Participants aux événements | Nombre de personnes présentes aux événements | Comptage | Par événement |
| Actions CLAS | Nb enfants accompagnés, nb séances | Pointage CLAS | Annuel |
| Actions ASL | Nb adultes en ateliers sociolinguistiques | Pointage ASL | Annuel |

---

## 5. Indicateurs Projet Familles

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Familles touchées | Nb de familles ayant participé à au moins 1 action famille | Fichier familles | Annuel |
| Actions collectives familles | Nb d'actions collectives réalisées | Planning | Annuel |
| Sorties familles | Nb de sorties organisées + nb de familles participantes | Bilan sorties | Annuel |
| Actions parentalité | Nb d'ateliers/groupes de parole parentalité | Planning | Annuel |
| Orientations réalisées | Nb de familles orientées vers des partenaires | Suivi référent | Annuel |
| Satisfaction familles | % de satisfaction (enquête) | Enquête | Annuel |
| Temps référent·e Familles | ETP dédié au projet familles | RH | Annuel |

---

## 6. Indicateurs financiers

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Budget total | Total des charges | Comptabilité | Annuel |
| Résultat net | Produits - Charges | Comptabilité | Annuel |
| Taux de dépendance CAF | Financement CAF / Budget total × 100 | Comptabilité | Annuel |
| Diversification des financements | Nb de financeurs / répartition des produits | Comptabilité | Annuel |
| Coût par usager | Budget total / nb usagers | Calcul | Annuel |
| Coût par journée-enfant | Budget ALSH / nb journées-enfants | Calcul | Annuel |
| Masse salariale / budget | Charges personnel / Total charges × 100 | Comptabilité | Annuel |
| Trésorerie | Jours de trésorerie disponible | Comptabilité | Mensuel |
| Ratio participations familles | Participations usagers / Total produits × 100 | Comptabilité | Annuel |

---

## 7. Indicateurs RH

| Indicateur | Définition | Source | Fréquence |
|-----------|-----------|--------|-----------|
| Effectif total (ETP) | Nombre d'ETP salariés | RH | Annuel |
| Turnover | Nb départs / effectif moyen × 100 | RH | Annuel |
| Absentéisme | Nb jours d'absence / nb jours travaillés théoriques × 100 | RH | Annuel |
| Heures de formation | Total heures de formation continue | Plan de formation | Annuel |
| Services civiques | Nb de volontaires accueillis | RH | Annuel |
| Stagiaires | Nb de stagiaires accueillis | RH | Annuel |

---

## 8. Indicateurs SENACS (saisie annuelle)

> Ces indicateurs sont ceux demandés dans le questionnaire SENACS annuel

| Thématique | Exemples d'indicateurs |
|-----------|----------------------|
| Identité | Statut, territoire, année de création, agrément |
| Ressources humaines | Effectifs salariés/bénévoles, qualification du directeur |
| Gouvernance | Type de gestion, composition CA, fréquence CA |
| Territoire | QPV, périmètre, population couverte |
| Public | Nb adhérents, profil socio (QF, âge, genre) |
| Activités | Secteurs d'activité, types d'actions, partenariats |
| Projet social | Axes prioritaires, projet familles, participation |
| Finances | Budget, sources de financement, PS CAF |

---

## 9. Tableau de bord synthétique (modèle)

| Domaine | Indicateur clé | N-1 | Objectif N | Réalisé N | Tendance |
|---------|---------------|-----|-----------|----------|---------|
| Fréquentation | Nb usagers total | | | | ↗️↘️➡️ |
| Mixité | % usagers QF < seuil | | | | |
| Participation | Nb bénévoles actifs | | | | |
| Familles | Nb familles touchées | | | | |
| Enfance | Taux occupation ALSH | | | | |
| Jeunesse | Nb jeunes accompagnés | | | | |
| Financier | Résultat net | | | | |
| RH | Turnover | | | | |

---

## Bonnes pratiques

1. **Choisir 10-15 indicateurs clés** maximum pour le tableau de bord direction
2. **Automatiser la collecte** via le logiciel de gestion (Aiga, NovaGestion, Inoe, etc.)
3. **Croiser quantitatif et qualitatif** : les chiffres seuls ne suffisent pas
4. **Comparer dans le temps** (N/N-1) et avec des structures comparables
5. **Partager les indicateurs** avec l'équipe, le CA, et les partenaires
6. **Actualiser à rythme régulier** : mensuel pour l'opérationnel, trimestriel pour le pilotage, annuel pour le stratégique
7. **Aligner les indicateurs** avec les axes du projet social
8. **Préparer SENACS** : les indicateurs de pilotage doivent faciliter la saisie SENACS annuelle

---

*Ce référentiel est indicatif. Adapter selon la taille de la structure, les exigences de la Caf locale et les axes du projet social.*
