# Processus d'agrément CAF — Centre social

## 1. Qu'est-ce que l'agrément ?

L'agrément « centre social » ou « espace de vie sociale » est une **reconnaissance institutionnelle** délivrée par le Conseil d'Administration de la Caf. Il atteste que la structure remplit les conditions pour exercer les missions d'Animation de la Vie Sociale (AVS) sur un territoire donné.

**L'agrément ouvre droit aux financements Caf** (prestations de service AVS et subventions complémentaires).

---

## 2. Conditions préalables

### 2.1 Pour un centre social

Pour être agréé « centre social », la structure doit :

- Disposer d'un **local identifié** et adapté (accueil du public, bureaux, salles d'activités)
- Couvrir un **territoire cohérent** (quartier, commune, intercommunalité)
- Avoir une **équipe professionnelle** avec au minimum un **directeur qualifié** (niveau II minimum, soit bac+3/4 en développement social, animation, gestion)
- Proposer une **animation globale** (pas uniquement sectorielle)
- Mettre en œuvre une **démarche participative** des habitants
- Être ouverte à **l'ensemble de la population** du territoire

### 2.2 Pour un EVS (Espace de Vie Sociale)

Conditions plus souples :
- Local adapté (peut être partagé)
- Animation de proximité (peut être thématique)
- Pas d'obligation de directeur qualifié (animateur référent suffit)
- Démarche participative adaptée

---

## 3. Le projet social — Document central

### 3.1 Contenu obligatoire

Le projet social doit comporter les éléments suivants :

#### A. Présentation de la structure
- Historique
- Statut juridique
- Gouvernance
- Moyens humains (organigramme, ETP)
- Moyens matériels (locaux, équipements)
- Budget prévisionnel sur 4 ans

#### B. Diagnostic social concerté du territoire
- **Données quantitatives** : population, revenus, emploi, logement, familles, allocataires Caf
- **Données qualitatives** : parole des habitants, perception des acteurs, observation de terrain
- **Analyse croisée** : besoins identifiés, ressources existantes, carences
- **Concertation** : méthodologie participative utilisée (enquêtes, réunions, ateliers)

#### C. Bilan du projet social précédent (si renouvellement)
- Résultats par axe et objectif
- Analyse des réussites et difficultés
- Enseignements tirés

#### D. Axes d'intervention et objectifs
- **3 à 5 axes stratégiques** cohérents avec le diagnostic
- Pour chaque axe :
  - Objectifs généraux
  - Objectifs opérationnels
  - Actions prévues
  - Indicateurs de résultat
  - Calendrier prévisionnel
  - Moyens mobilisés

#### E. Référencement aux finalités AVS
Démontrer comment le projet contribue aux 3 finalités :
1. Inclusion sociale et socialisation
2. Développement des liens sociaux et cohésion
3. Prise de responsabilité et citoyenneté de proximité

#### F. Participation des habitants
- Modalités de participation à l'élaboration du projet
- Instances participatives prévues
- Objectifs en matière de pouvoir d'agir

#### G. Projet Familles (si demande de PS AVS Familles)
- Diagnostic « familles » spécifique
- Objectifs et actions par axe (4 axes obligatoires)
- Poste de référent Familles (ETP, profil, missions)
- Partenariats mobilisés
- Budget dédié

---

## 4. Processus d'agrément étape par étape

### Étape 1 : Préparation (12 à 6 mois avant l'échéance)

| Action | Acteur | Délai |
|---|---|---|
| Lancement de la démarche de diagnostic | Direction + CA | M-12 |
| Collecte des données territoriales | Équipe | M-12 à M-8 |
| Consultation des habitants | Équipe + habitants | M-10 à M-6 |
| Consultation des partenaires | Direction | M-8 à M-6 |
| Bilan du projet social sortant | Direction + équipe | M-10 à M-6 |

### Étape 2 : Rédaction (6 à 3 mois avant)

| Action | Acteur | Délai |
|---|---|---|
| Rédaction du diagnostic | Direction (+ appui Caf si besoin) | M-6 à M-4 |
| Définition des axes et objectifs | CA + équipe + habitants | M-5 à M-3 |
| Rédaction complète du projet social | Direction | M-4 à M-2 |
| Validation par le CA de la structure | CA | M-2 |

### Étape 3 : Instruction (2 à 0 mois avant)

| Action | Acteur | Délai |
|---|---|---|
| Dépôt du dossier à la Caf | Direction | M-2 |
| Instruction par le conseiller technique Caf | Caf | M-2 à M-1 |
| Échanges / compléments éventuels | Caf ↔ Centre | M-1 |
| Avis du conseiller technique | Caf | M-1 |
| Présentation au CA de la Caf | Caf | M-0 |
| **Décision d'agrément** | **CA de la Caf** | **M-0** |

### Étape 4 : Formalisation

| Action | Acteur |
|---|---|
| Notification de l'agrément | Caf → Centre |
| Signature de la COF | Caf ↔ Centre |
| Mise en œuvre du projet social | Centre |

---

## 5. Critères d'évaluation par la Caf

Le conseiller technique Caf évalue le dossier sur :

### Critères de forme
- [ ] Complétude du dossier (toutes les parties présentes)
- [ ] Qualité rédactionnelle et lisibilité
- [ ] Cohérence interne (diagnostic → axes → objectifs → indicateurs)
- [ ] Budget prévisionnel réaliste et détaillé

### Critères de fond
- [ ] Qualité et profondeur du diagnostic territorial
- [ ] Degré de participation des habitants dans l'élaboration
- [ ] Pertinence des axes au regard du diagnostic
- [ ] Adéquation avec les finalités AVS
- [ ] Qualité des indicateurs (mesurables, réalistes)
- [ ] Prise en compte des publics les plus éloignés
- [ ] Cohérence avec les priorités Caf et les politiques publiques locales
- [ ] Qualité de la gouvernance et de la vie associative
- [ ] Adéquation des moyens humains (qualification du directeur)

### Pour le projet Familles (en sus)
- [ ] Diagnostic Familles spécifique
- [ ] 4 axes obligatoires couverts
- [ ] Poste de référent Familles identifié et qualifié
- [ ] Actions concrètes et calendrier
- [ ] Partenariats Familles formalisés

---

## 6. Cas particuliers

### 6.1 Premier agrément (création)
- Étude de faisabilité préalable recommandée
- Diagnostic territorial particulièrement approfondi
- Peut être précédé d'une phase de « préfiguration » (1-2 ans)
- Agrément initial parfois limité à 2 ans (probatoire)

### 6.2 Renouvellement
- Bilan du projet social sortant obligatoire
- Continuité attendue avec les acquis
- Prise en compte des évolutions du territoire

### 6.3 Agrément conditionnel
- La Caf peut assortir l'agrément de **réserves** ou **recommandations**
- Suivi renforcé par le conseiller technique
- Point d'étape à mi-parcours obligatoire

### 6.4 Non-renouvellement ou retrait
- En cas de manquements graves :
  - Non-respect du projet social
  - Difficultés financières majeures
  - Absence de participation des habitants
  - Problèmes de gouvernance
- Procédure contradictoire obligatoire
- Accompagnement possible vers un plan de redressement

---

## 7. Financements associés à l'agrément

### 7.1 Prestations de service (PS)

| PS | Objet | Base de calcul |
|---|---|---|
| **PS AVS Animation globale** | Fonctionnement global du centre | Montant forfaitaire national (révisé annuellement par la CNAF) |
| **PS AVS Familles** | Projet Familles + référent | % du coût du poste de référent + actions |

### 7.2 Dotation action sociale

Subventions complémentaires décidées localement par le CA de la Caf :
- **Aide au fonctionnement** : complément à la PS
- **Aide au démarrage** : pour les nouveaux agréments
- **Aide à l'investissement** : travaux, équipements
- **Aide sur projets** : actions spécifiques (numérique, transition écologique, etc.)

### 7.3 Autres financements mobilisables

| Financeur | Type |
|---|---|
| Commune / EPCI | Subvention, mise à disposition locaux |
| Département | Subvention (compétence action sociale) |
| État (DDCS/PP) | Contrat de ville, FDVA, politique de la ville |
| Région | Formation, fonds européens (FSE) |
| Fondations | Mécénat, appels à projets |
| CAF (hors AVS) | CLAS, REAAP, LAEP (prestations spécifiques) |

---

## 8. Checklist — Dossier de demande d'agrément

### Documents à fournir à la Caf

- [ ] Projet social complet (diagnostic + axes + indicateurs)
- [ ] Projet Familles (si demande PS Familles)
- [ ] Statuts de l'association (ou délibération municipale)
- [ ] Composition du CA et du bureau
- [ ] PV de la dernière AG
- [ ] Organigramme de l'équipe
- [ ] CV et diplômes du directeur
- [ ] Budget prévisionnel N à N+3
- [ ] Comptes annuels N-1 (bilan + compte de résultat)
- [ ] Rapport du commissaire aux comptes (si applicable)
- [ ] Bilan du projet social précédent (si renouvellement)
- [ ] Rapport SENACS N-1
- [ ] Plan des locaux
- [ ] Conventions de partenariat principales
- [ ] Lettre d'engagement du CA (ou du maire)
