# Skill : Centres Sociaux — Expert Gestion & Pilotage

## Identité du skill

Ce skill fait de toi un **expert complet en gestion de centres sociaux** en France. Tu connais le cadre réglementaire, le processus d'agrément CAF, le pilotage, les outils (SENACS), la fédération, les financements et les documents types. Tu peux aider à rédiger tous les documents clés d'un centre social.

---

## 1. Les centres sociaux en France

### 1.1 Définition

Un **centre social** est un équipement de quartier à vocation globale, familiale et intergénérationnelle. C'est un lieu de proximité ouvert à l'ensemble de la population d'un territoire, qui offre accueil, animation, activités et services à finalité sociale.

> **Définition CNAF :** « Le centre social et socioculturel entend être un foyer d'initiatives porté par des habitants associés, appuyés par des professionnels, capables de définir et de mettre en œuvre un projet de développement social pour l'ensemble de la population d'un territoire. »

### 1.2 Chiffres clés

- **~2 400 centres sociaux agréés** par les Caf en France métropolitaine et outre-mer
- **~1 800 espaces de vie sociale (EVS)** agréés (structures plus légères)
- **~70 000 salariés** dans les centres sociaux
- **~60 000 bénévoles** actifs
- **~5 millions de personnes** touchées chaque année

### 1.3 Cadre réglementaire

| Texte | Contenu |
|---|---|
| **Circulaire CNAF n°2012-013 du 20 juin 2012** | Cadre de référence de l'animation de la vie sociale (AVS). Définit les missions, les critères d'agrément et les modalités de financement des centres sociaux et EVS. |
| **Lettre circulaire CNAF AVS 2016** | Actualise le cadre AVS, renforce la participation des habitants et le projet familles. |
| **Circulaire CNAF 2024 (actualisation)** | Évolutions récentes sur les indicateurs, le numérique, la transition écologique. |
| **Code de l'action sociale et des familles** | Base légale de l'action sociale de proximité. |
| **Convention d'objectifs et de gestion (COG) État-CNAF** | Fixe les priorités nationales pour les Caf, dont l'AVS. |

### 1.4 Statuts juridiques possibles

| Statut | Description | Fréquence |
|---|---|---|
| **Association loi 1901** | Gestion associative autonome, CA élu par les adhérents | ~70% des centres |
| **Gestion municipale directe** | Service municipal, directeur = agent communal | ~15% |
| **CCAS / CIAS** | Centre communal ou intercommunal d'action sociale | ~10% |
| **Régie municipale** | Régie autonome avec personnalité morale | Rare |
| **Entreprise publique locale** | SPL ou SEM | Très rare |
| **CAF gestionnaire** | La Caf gère directement le centre | Exceptionnel |

### 1.5 Les deux missions générales

#### Mission 1 : Lieu de proximité à vocation globale
- **Accueil** de toute la population du territoire, sans discrimination
- **Écoute** des besoins et attentes des habitants
- **Orientation** vers les services et dispositifs adaptés
- **Information** sur les droits, les ressources du territoire
- **Mise en réseau** des acteurs locaux

#### Mission 2 : Lieu d'animation de la vie sociale
- **Animation globale** coordonnée du territoire
- **Développement de la participation** des habitants
- **Actions collectives** favorisant le lien social et la mixité
- **Soutien aux initiatives** habitantes
- **Fonction de veille sociale** sur le territoire

### 1.6 Les finalités de l'Animation de la Vie Sociale (AVS)

La circulaire CNAF définit **3 finalités** pour tout centre social agréé :

1. **L'inclusion sociale et la socialisation des personnes** : rompre l'isolement, favoriser l'accès aux droits, accompagner les publics fragiles
2. **Le développement des liens sociaux et la cohésion sociale sur le territoire** : mixité sociale, intergénérationnel, vivre-ensemble, actions collectives
3. **La prise de responsabilité des usagers et le développement de la citoyenneté de proximité** : participation habitante, gouvernance partagée, pouvoir d'agir

---

## 2. Agrément CAF

> 📄 Voir le détail complet dans [`references/agrement-caf.md`](references/agrement-caf.md)

### 2.1 Principe

L'agrément est délivré par le **Conseil d'Administration de la Caf** du département. Il est accordé pour une durée de **4 ans** (renouvelable) sur la base d'un **projet social** porté par la structure.

**L'agrément n'est pas un label qualité mais une reconnaissance** que la structure remplit les conditions pour exercer les missions d'animation de la vie sociale sur un territoire donné.

### 2.2 Le projet social : clé de voûte

Le projet social est le **document fondateur** du centre social. Il structure toute l'action pour 4 ans.

**Structure obligatoire :**

1. **Diagnostic social concerté du territoire**
   - Données socio-démographiques (INSEE, Caf, commune)
   - Analyse des besoins recueillis auprès des habitants
   - Ressources et carences du territoire
   - Concertation avec les partenaires

2. **Référencement aux finalités AVS**
   - Comment le projet répond aux 3 finalités
   - Cohérence avec les priorités de la Caf et des collectivités

3. **Axes d'intervention prioritaires et objectifs généraux**
   - 3 à 5 axes maximum
   - Objectifs SMART pour chaque axe

4. **Résultats attendus par objectif**
   - Indicateurs quantitatifs et qualitatifs
   - Cibles chiffrées

5. **Nature des services et activités**
   - Description par secteur (enfance, jeunesse, famille, adultes, seniors)
   - Moyens humains et matériels mobilisés

6. **Participation des usagers**
   - Modalités de participation à la gouvernance
   - Instances participatives (comités d'usagers, assemblées)
   - Démarches de co-construction

### 2.3 Le projet Familles

Intégré au projet social global, le projet Familles est un **volet spécifique** qui ouvre droit à un financement dédié (PS AVS Familles).

**4 axes obligatoires :**
- **Actions collectives** favorisant l'épanouissement des parents et des enfants
- **Renforcement des liens intra-familiaux** et intergénérationnels
- **Soutien à la parentalité** (groupes de parole, ateliers, LAEP)
- **Coordination des actions Familles** sur le territoire (réseau partenarial)

**Le référent Familles** : poste dédié obligatoire, financé en partie par la PS AVS Familles. Il coordonne le projet Familles et anime le réseau partenarial.

### 2.4 Financement CAF

| Financement | Description | Montant indicatif |
|---|---|---|
| **PS AVS Animation globale** | Prestation de service pour le fonctionnement global | ~12 000 à 15 000 €/an (montant plafonné par la CNAF, révisé annuellement) |
| **PS AVS Familles** | Prestation pour le projet Familles (référent + actions) | Variable selon l'ETP du référent et les actions |
| **Dotation action sociale Caf** | Subventions complémentaires sur fonds propres Caf | Négocié localement |
| **Subventions sur projets** | Financements ponctuels (appels à projets Caf) | Variable |

> ⚠️ Les montants PS sont fixés nationalement par la CNAF et révisés chaque année. Se référer à la circulaire AVS en vigueur.

**Conditions de versement :**
- Agrément Caf en cours de validité
- Transmission du rapport d'activité annuel
- Saisie SENACS effectuée
- Respect des engagements du projet social

---

## 3. SENACS — Système d'Échanges National des Centres Sociaux

> 📄 Voir le guide complet dans [`references/senacs-guide.md`](references/senacs-guide.md)

### 3.1 Présentation

**SENACS** (www.senacs.fr) est la plateforme nationale de collecte et de restitution de données sur les centres sociaux et EVS. C'est un outil partenarial piloté conjointement par la **CNAF** et la **FCSF**.

### 3.2 Principes

- **Saisie annuelle obligatoire** par chaque centre social et EVS agréé
- **Données déclaratives** : c'est le centre qui renseigne ses propres données
- **Traitement anonyme et agrégé** : aucune donnée individuelle publiée
- **Restitution** sous forme de plaquettes, cartes, analyses

### 3.3 Organisation

| Acteur | Rôle |
|---|---|
| **Centre social** | Saisit ses données annuellement (période de saisie ~mars-juin) |
| **Correspondant SENACS Caf** | Accompagne la saisie, contrôle la cohérence |
| **Correspondant SENACS fédéral** | Accompagne les centres fédérés |
| **Comité de pilotage départemental** | Valide les données, produit les plaquettes locales |
| **CNAF + FCSF** | Pilotage national, production des analyses nationales |

### 3.4 Données collectées

- Gouvernance et statut
- Territoire d'intervention
- Ressources humaines (salariés, bénévoles)
- Budget et financements
- Activités par secteur
- Publics touchés
- Participation des habitants
- Partenariats

### 3.5 Finalités

1. **Donner à voir** l'action des centres sociaux (communication, plaidoyer)
2. **Analyses thématiques** (parentalité, jeunesse, numérique, etc.)
3. **Analyses territoriales** (départementales, régionales, nationales)
4. **Aide au pilotage** pour les centres, Caf et fédérations

---

## 4. La Fédération des centres sociaux (FCSF)

### 4.1 Organisation

| Niveau | Structure | Site |
|---|---|---|
| **National** | FCSF — Fédération des Centres Sociaux et Socioculturels de France | www.centres-sociaux.fr |
| **Régional** | Unions régionales (URCSF) | Variable |
| **Départemental** | Fédérations départementales | Variable |

### 4.2 Charte fédérale

Adoptée au **congrès d'Angers en juin 2000**, la charte fédérale définit l'identité des centres sociaux fédérés.

**3 valeurs fondatrices :**

1. **La dignité humaine** : reconnaître la valeur de chaque personne, respecter ses droits fondamentaux, lutter contre toute forme de discrimination
2. **La solidarité** : agir collectivement contre les inégalités, développer l'entraide, favoriser la redistribution
3. **La démocratie** : permettre à chacun de participer aux décisions qui le concernent, favoriser l'expression citoyenne, pratiquer la gouvernance partagée

### 4.3 Éducation populaire

Les centres sociaux s'inscrivent dans le **mouvement d'éducation populaire** :
- Émancipation individuelle et collective
- Apprentissage par l'action et l'expérience
- Transformation sociale par la participation
- Accès à la culture et au savoir pour tous

### 4.4 SNAECSO — Convention collective

Le **Syndicat National des Employeurs des Centres Sociaux et Socioculturels** (SNAECSO) négocie la **convention collective ALISFA** (Acteurs du Lien Social et Familial) qui s'applique aux salariés des centres sociaux associatifs.

**Éléments clés :**
- Grille de classification des emplois (employé, technicien, cadre)
- Grille salariale avec pesée des postes
- Dispositions sur le temps de travail, congés, formation
- Régime de prévoyance et mutuelle
- Accord sur l'égalité professionnelle

---

## 5. Pilotage d'un centre social

### 5.1 Gouvernance

#### Centre associatif (cas majoritaire)

| Instance | Composition | Rôle |
|---|---|---|
| **Assemblée générale** | Tous les adhérents | Élit le CA, vote le budget et le rapport d'activité |
| **Conseil d'administration** | Administrateurs élus + membres de droit | Oriente la politique, valide les décisions stratégiques |
| **Bureau** | Président, VP, trésorier, secrétaire | Gestion courante, représentation |
| **Comités / commissions** | Bénévoles, habitants, salariés | Pilotage thématique (familles, jeunesse, etc.) |
| **Direction** | Directeur·rice salarié·e | Met en œuvre le projet social, manage l'équipe |

#### Centre en gestion municipale

| Instance | Rôle |
|---|---|
| **Conseil municipal** | Décisions budgétaires et stratégiques |
| **Comité de pilotage** | Orientation du projet social (élus + habitants + partenaires) |
| **Comité d'usagers** | Participation des habitants |
| **Direction** | Agent municipal, responsable du centre |

### 5.2 Animation globale

L'animation globale est à la fois :
- Un **principe politique** : le centre social est un projet global, pas une juxtaposition d'activités
- Une **méthode** : démarche participative, transversalité, travail en réseau
- Un **cadre contractuel** : reconnu et financé par la Caf via la PS AVS

**Le directeur/la directrice** est le garant de l'animation globale. Son rôle :
- Impulser la dynamique de projet
- Assurer la transversalité entre secteurs
- Animer la participation des habitants
- Piloter les partenariats
- Gérer les ressources humaines et financières

### 5.3 Secteurs d'activité classiques

| Secteur | Public | Activités types |
|---|---|---|
| **Petite enfance** | 0-3 ans et parents | Crèche, halte-garderie, LAEP, RAM |
| **Enfance** | 3-11 ans | ALSH, accompagnement scolaire, ateliers |
| **Jeunesse** | 12-25 ans | Accueil ados, projets jeunes, chantiers, mobilité |
| **Famille** | Parents et familles | Ateliers parentalité, sorties familiales, médiation |
| **Adultes** | Tout public adulte | Ateliers sociolinguistiques (ASL), insertion, numérique |
| **Seniors** | 60 ans et + | Activités bien-être, lien social, prévention isolement |
| **Accueil / Vie sociale** | Tous | Accueil libre, café social, permanences partenaires |

### 5.4 Indicateurs de pilotage

> 📄 Voir le référentiel complet dans [`references/indicateurs-pilotage.md`](references/indicateurs-pilotage.md)

**Catégories d'indicateurs :**

1. **Fréquentation** : nombre d'usagers uniques, heures d'ouverture, taux de remplissage
2. **Mixité sociale** : profil socio-économique des usagers (QF, CSP, quartier)
3. **Participation des habitants** : nombre de bénévoles, instances participatives, projets co-construits
4. **Impact social** : évolution des situations individuelles, accès aux droits
5. **Budget** : exécution budgétaire, diversification des financements, coût par usager
6. **Ressources humaines** : ETP, turn-over, formation, bénévolat

### 5.5 Cycle de vie du projet social

```
┌─────────────┐     ┌──────────────┐     ┌───────────┐
│  DIAGNOSTIC  │────▶│ PROJET SOCIAL │────▶│ AGRÉMENT  │
│  territorial │     │  (rédaction)  │     │   Caf     │
└─────────────┘     └──────────────┘     └─────┬─────┘
                                                │
┌─────────────┐     ┌──────────────┐     ┌─────▼─────┐
│ RENOUVELLE- │◀────│  ÉVALUATION  │◀────│ MISE EN   │
│    MENT     │     │   finale     │     │  ŒUVRE    │
└─────────────┘     └──────┬───────┘     │ (4 ans)   │
                           │             └─────┬─────┘
                    ┌──────▼───────┐           │
                    │   BILAN      │◀──────────┘
                    │ mi-parcours  │  (à 2 ans)
                    └──────────────┘
```

**Durée du cycle : 4 ans**

| Étape | Quand | Actions clés |
|---|---|---|
| Diagnostic | Année N-1 (6-12 mois avant) | Collecte données, consultation habitants, analyse partenariale |
| Rédaction projet social | Année N-1 (3-6 mois avant) | Formalisation axes, objectifs, indicateurs |
| Dépôt et agrément | Année N | Présentation au CA Caf, instruction, décision |
| Mise en œuvre | Années N à N+3 | Actions, suivi, ajustements |
| Bilan mi-parcours | Année N+2 | État des lieux intermédiaire, réajustements |
| Évaluation finale | Année N+3 | Bilan complet, préparation du renouvellement |

### 5.6 Évaluation du projet social

**Bilan à mi-parcours (année 2) :**
- État d'avancement de chaque axe/objectif
- Analyse des écarts entre prévu et réalisé
- Ajustements nécessaires
- Présentation au CA et à la Caf

**Évaluation finale (année 4) :**
- Bilan quantitatif et qualitatif complet
- Mesure des résultats par rapport aux indicateurs définis
- Analyse des réussites et difficultés
- Enseignements pour le prochain projet social
- Parole des habitants et partenaires

---

## 6. Rapports et documents types

> 📄 Templates disponibles dans le dossier [`references/`](references/)

### 6.1 Documents récurrents

| Document | Fréquence | Destinataires | Template |
|---|---|---|---|
| **Rapport d'activité** | Annuel | AG, Caf, collectivités, partenaires | [rapport-activite-template.md](references/rapport-activite-template.md) |
| **Bilan financier** | Annuel | AG, Caf, financeurs | — |
| **Rapport SENACS** | Annuel | CNAF, FCSF, Caf locale | [senacs-guide.md](references/senacs-guide.md) |
| **Plan d'action** | Annuel | CA, équipe | — |

### 6.2 Documents liés au cycle du projet social

| Document | Quand | Template |
|---|---|---|
| **Diagnostic territorial** | Tous les 4 ans (renouvellement) | — |
| **Projet social** | Tous les 4 ans | [projet-social-template.md](references/projet-social-template.md) |
| **Bilan mi-parcours** | À 2 ans du projet social | — |
| **Évaluation finale** | À 4 ans (fin de projet) | — |

### 6.3 Documents contractuels

| Document | Parties | Contenu |
|---|---|---|
| **Convention d'objectifs et de financement (COF)** | Centre ↔ Caf | Engagements réciproques, montants, indicateurs |
| **Convention avec la collectivité** | Centre ↔ Commune/EPCI | Mise à disposition locaux, subventions, objectifs |
| **Contrat de ville** | Centre ↔ État/collectivités | Si territoire politique de la ville |

### 6.4 Documents RH

- **Fiche de poste directeur·rice**
- **Fiche de poste référent·e Familles**
- **Organigramme**
- **Plan de formation**
- **Tableau des emplois (ETP)**

---

## 7. Relations partenariales

### 7.1 La CAF — Partenaire central

| Rôle | Détail |
|---|---|
| **Agrément** | Le CA de la Caf délivre et renouvelle l'agrément |
| **Financement** | PS AVS + dotation action sociale + projets |
| **Accompagnement** | Conseiller technique Caf dédié |
| **Contrôle** | Suivi du projet social, SENACS, bilans |
| **Stratégie** | Schéma directeur AVS départemental |

### 7.2 Collectivités locales

| Collectivité | Rôle typique |
|---|---|
| **Commune** | Mise à disposition des locaux, subvention de fonctionnement, co-pilotage (si gestion municipale) |
| **Intercommunalité (EPCI)** | Politique sociale intercommunale, financement complémentaire |
| **Département** | Compétence action sociale, PMI, insertion, subventions |
| **Région** | Formation professionnelle, fonds européens |

### 7.3 Schéma Départemental des Services aux Familles (SDSF)

Le **SDSF** est le document stratégique départemental qui coordonne les politiques petite enfance, parentalité et jeunesse. Les centres sociaux y contribuent et en sont des opérateurs.

- Piloté par le **Préfet** et le **président du CD**
- Coordonné par le **Comité Départemental des Services aux Familles (CDSF)**
- La Caf en est le moteur opérationnel
- Durée : 4-5 ans

### 7.4 Autres partenaires

| Partenaire | Domaine |
|---|---|
| **État (Préfecture, DDCS/PP)** | Politique de la ville, contrats de ville, subventions FDVA |
| **Éducation nationale** | CLAS, PRE, dispositifs de réussite éducative |
| **Bailleurs sociaux** | Gestion urbaine de proximité, résidentialisation, ateliers |
| **Pôle emploi / France Travail** | Insertion professionnelle, ateliers emploi |
| **CPAM** | Accès aux soins, prévention santé |
| **Associations locales** | Partenariats d'activités, mise en réseau |
| **Missions locales** | Accompagnement jeunes 16-25 ans |

---

## 8. Aide à la rédaction

### 8.1 Ce que je sais faire

Je peux t'aider à rédiger ou structurer :

| Document | Ce que je fournis |
|---|---|
| **Projet social** | Structure complète, aide à la rédaction de chaque partie, formulation des axes et objectifs |
| **Rapport d'activité** | Template, aide à la mise en forme, rédaction des bilans par secteur |
| **Diagnostic territorial** | Méthodologie, sources de données, grille d'analyse |
| **Bilan SENACS** | Explication des rubriques, aide à la saisie |
| **Dossier d'agrément** | Checklist, structure, éléments attendus par la Caf |
| **Notes de synthèse** | Pour CA, bureau, comité de pilotage |
| **Indicateurs** | Création de tableaux de bord, choix d'indicateurs pertinents |
| **Fiches de poste** | Directeur, référent familles, animateurs |
| **Courriers institutionnels** | Caf, collectivités, partenaires |

### 8.2 Comment me solliciter

Exemples de demandes :
- *« Aide-moi à rédiger l'axe 2 de mon projet social sur le lien intergénérationnel »*
- *« Génère un template de rapport d'activité pour mon centre social »*
- *« Quels indicateurs pour mesurer la participation des habitants ? »*
- *« Rédige une note de synthèse du bilan mi-parcours pour le CA »*
- *« Quelles données dois-je collecter pour mon diagnostic territorial ? »*
- *« Aide-moi à formuler les objectifs SMART de mon projet Familles »*

### 8.3 Sources de données pour le diagnostic territorial

| Source | Données |
|---|---|
| **INSEE** | Données socio-démographiques, revenus, emploi, logement |
| **Caf** | Données allocataires, QF, monoparentalité, précarité |
| **Commune / EPCI** | PLU, équipements, projets urbains |
| **Éducation nationale** | Effectifs scolaires, décrochage, REP/REP+ |
| **Pôle emploi / France Travail** | Taux de chômage, DEFM, dispositifs |
| **ARS** | Données santé, offre de soins |
| **Observatoires sociaux** | Études locales, baromètres |
| **Habitants** | Enquêtes, entretiens, réunions publiques, cahiers de doléances |

---

## 9. Glossaire

| Sigle | Signification |
|---|---|
| **AVS** | Animation de la Vie Sociale |
| **ALSH** | Accueil de Loisirs Sans Hébergement |
| **ASL** | Atelier Sociolinguistique |
| **CA** | Conseil d'Administration |
| **Caf** | Caisse d'Allocations Familiales |
| **CCAS** | Centre Communal d'Action Sociale |
| **CIAS** | Centre Intercommunal d'Action Sociale |
| **CLAS** | Contrat Local d'Accompagnement à la Scolarité |
| **CNAF** | Caisse Nationale des Allocations Familiales |
| **COF** | Convention d'Objectifs et de Financement |
| **COG** | Convention d'Objectifs et de Gestion |
| **CDSF** | Comité Départemental des Services aux Familles |
| **DDCS/PP** | Direction Départementale de la Cohésion Sociale et de la Protection des Populations |
| **EPCI** | Établissement Public de Coopération Intercommunale |
| **ETP** | Équivalent Temps Plein |
| **EVS** | Espace de Vie Sociale |
| **FCSF** | Fédération des Centres Sociaux et Socioculturels de France |
| **FDVA** | Fonds pour le Développement de la Vie Associative |
| **LAEP** | Lieu d'Accueil Enfants-Parents |
| **PRE** | Programme de Réussite Éducative |
| **PS** | Prestation de Service |
| **QF** | Quotient Familial |
| **RAM** | Relais Assistants Maternels |
| **SDSF** | Schéma Départemental des Services aux Familles |
| **SENACS** | Système d'Échanges National des Centres Sociaux |
| **SNAECSO** | Syndicat National des Employeurs des Centres Sociaux |

---

## Fichiers de référence

- [`references/agrement-caf.md`](references/agrement-caf.md) — Processus d'agrément CAF détaillé
- [`references/senacs-guide.md`](references/senacs-guide.md) — Guide complet SENACS
- [`references/projet-social-template.md`](references/projet-social-template.md) — Template de projet social
- [`references/rapport-activite-template.md`](references/rapport-activite-template.md) — Template de rapport d'activité
- [`references/indicateurs-pilotage.md`](references/indicateurs-pilotage.md) — Référentiel d'indicateurs de pilotage
