# Celo DeFi Contract Addresses

## Uniswap V3 - Mainnet (Chain ID: 42220)

| Contract | Address |
|----------|---------|
| Factory | 0xAfE208a311B21f13EF87E33A90049fC17A7acDEc |
| SwapRouter02 | 0x5615CDAb10dc425a742d643d949a7F474C01abc4 |
| QuoterV2 | 0x82825d0554fA07f7FC52Ab63c961F330fdEFa8E8 |
| NonfungiblePositionManager | 0x3d79EdAaBC0EaB6F08ED885C05Fc0B014290D95A |
| UniversalRouter | 0x643770E279d5D0733F21d6DC03A8efbABf3255B4 |
| Permit2 | 0x000000000022D473030F116dDEE9F6B43aC78BA3 |
| TickLens | 0x5f115D9113F88e0a0Db1b5033D90D4a9690AcD3D |
| Multicall2 | 0x633987602DE5C4F337e3DbF265303A1080324204 |
| v3Staker | 0x6586FB35393abF7Ff454977a9b3c912d218791C6 |

Source: https://docs.uniswap.org/contracts/v3/reference/deployments/celo-deployments

## Uniswap V3 - Alfajores Testnet

| Contract | Address |
|----------|---------|
| Factory | 0x229Fd76DA9062C1a10eb4193768E192bdEA99572 |
| SwapRouter02 | 0x8C456F41A3883bA0ba99f810F7A2Da54D9Ea3EF0 |
| QuoterV2 | 0x3c1FCF8D6f3A579E98F4AE75EB0adA6de70f5673 |
| NonfungiblePositionManager | 0x0eC9d3C06Bc0A472A80085244d897bb604548824 |
| UniversalRouter | 0x84904B9E85F76a421223565be7b596d7d9A8b8Ce |
| Permit2 | 0x000000000022D473030F116dDEE9F6B43aC78BA3 |

Source: https://docs.uniswap.org/contracts/v3/reference/deployments/celo-deployments

## Uniswap V4 - Mainnet

| Contract | Address |
|----------|---------|
| PoolManager | 0x288dc841A52FCA2707c6947B3A777c5E56cd87BC |
| PositionManager | 0xf7965f3981e4d5bc383bfbcb61501763e9068ca9 |
| V4Quoter | 0x28566da1093609182dff2cb2a91cfd72e61d66cd |
| UniversalRouter | 0xcb695bc5d3aa22cad1e6df07801b061a05a0233a |

Source: https://docs.celo.org/tooling/contracts/uniswap-contracts

## Ubeswap - Mainnet

| Contract | Address |
|----------|---------|
| V3 Factory | 0x67FEa58D5a5a4162cED847E13c2c81c73bf8aeC4 |
| V3 Universal Router | 0x3C255DED9B25f0BFB4EF1D14234BD2514d7A7A0d |
| V3 NFT Position Manager | 0x897387c7B996485c3AAa85c94272Cd6C506f8c8F |
| V2 Factory | 0x62d5b84bE28a183aBB507E125B384122D2C25fAE |
| V2 Router | 0xE3D8bd6Aed4F159bc8000a9cD47CffDb95F96121 |
| UBE Token | 0x71e26d0E519D14591b9dE9a0fE9513A398101490 |
| V3 Farm Protocol | 0xA6E9069CB055a425Eb41D185b740B22Ec8f51853 |
| UBE Votable Staking | 0x388D611A57Ac15dCC1B937f287E5E908Ba5ff5c9 |

Source: https://docs.ubeswap.org/code-contracts/contract-addresses

## Aave V3 - Mainnet

| Contract | Address |
|----------|---------|
| Pool | 0x3E59A31363E2ad014dcbc521c4a0d5757d9f3402 |
| PoolAddressesProvider | 0x9F7Cf9417D5251C59fE94fB9147feEe1aAd9Cea5 |
| PoolConfigurator | 0x7567E3434CC1BEf724AB595e6072367Ef4914691 |
| Oracle | 0x1e693D088ceFD1E95ba4c4a5F7EeA41a1Ec37e8b |
| ACLManager | 0x7a12dCfd73C1B4cddf294da4cFce75FcaBBa314C |
| PoolDataProvider | 0x2e0f8D3B1631296cC7c56538D6Eb6032601E15ED |
| Collector | 0xC959439207dA5341B74aDcdAC59016aa9Be7E9E7 |
| ConfigEngine | 0xeFb0e084Ba4C1262D89D8d5C3Bb304c42A853311 |
| Pool Implementation | 0x4A1DDf2757666a474CcCEBA735A9f69ed22b75a8 |
| Default Incentives Controller | 0x4725A0FdbEB14A77964bC1C221eE3a7982263103 |

Source: https://github.com/bgd-labs/aave-address-book (AaveV3Celo.sol)

## Aave V3 Supported Assets - Mainnet

| Asset | Token Address | aToken Address |
|-------|---------------|----------------|
| USDC | 0xcebA9300f2b948710d2653dD7B07f33A8B32118C | 0xFF8309b9e99bfd2D4021bc71a362aBD93dBd4785 |
| USDT | 0x48065fbbe25f71c9282ddf5e1cd6d6a887483d5e | - |
| USDm | 0x765de816845861e75a25fca122bb6898b8b1282a | - |
| EURm | 0xd8763cba276a3738e6de85b4b3bf5fded6d6ca73 | - |
| CELO | 0x471EcE3750Da237f93B8E339c536989b8978a438 | - |
| WETH | 0xD221812de1BD094f35587EE8E174B07B6167D9Af | - |

## Common Tokens - Mainnet

| Token | Address | Decimals |
|-------|---------|----------|
| CELO (wrapped) | 0x471EcE3750Da237f93B8E339c536989b8978a438 | 18 |
| USDm | 0x765de816845861e75a25fca122bb6898b8b1282a | 18 |
| EURm | 0xd8763cba276a3738e6de85b4b3bf5fded6d6ca73 | 18 |
| USDC | 0xcebA9300f2b948710d2653dD7B07f33A8B32118C | 6 |
| USDT | 0x48065fbbe25f71c9282ddf5e1cd6d6a887483d5e | 6 |
| WETH | 0xD221812de1BD094f35587EE8E174B07B6167D9Af | 18 |

## Notes

- CELO is the native asset but has a wrapped version for DeFi interactions
- Always verify addresses on Celoscan before use
- Use the official Aave Address Book package for up-to-date addresses: `@bgd-labs/aave-address-book`
