# Bridged Tokens on Celo

## Natively Bridged Tokens (Ethereum → Celo)

These tokens are officially bridged via the native Celo bridge.

Source: https://docs.celo.org/home/bridged-tokens

### Stablecoins

| Token | Symbol | L1 Address (Ethereum) | L2 Address (Celo) |
|-------|--------|----------------------|-------------------|
| Dai | DAI | 0x6B175474E89094C44Da98b954EedeAC495271d0F | 0xac177de2439bd0c7659c61f373dbf247d1f41abe |
| crvUSD | crvUSD | 0xf939E0A03FB07F59A73314E73794Be0E57ac1b4E | 0x9efd56a126a0e3a8782db5fd5adb23a8dd9023c6 |
| LUSD | LUSD | 0x5f98805a4e8be255a32880fdec7f6728c6568ba0 | 0xef6379fa3090310862a42f6c732dba2f20880f0a |
| DOLA | DOLA | 0x865377367054516e17014CcdED1e7d814EDC9ce4 | 0x31f01af056b7e829bd41e59e8ba3d2313d2b0ff3 |

### Wrapped Assets

| Token | Symbol | L1 Address (Ethereum) | L2 Address (Celo) |
|-------|--------|----------------------|-------------------|
| Wrapped Ether | WETH | 0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2 | 0xD221812de1BD094f35587EE8E174B07B6167D9Af |
| Wrapped Bitcoin | WBTC | 0x2260fac5e5542a773aa44fbcfedf7c193bc2c599 | 0x8aC2901Dd8A1F17a1A4768A6bA4C3751e3995B2D |
| Rocket Pool ETH | rETH | 0xae78736cd615f374d3085123a210448e74fc6393 | 0x55f3d16e6bd2b8b8e6599df6ef4593ce9dcae9ed |
| Savings DAI | sDAI | 0x83F20F44975D03b1b09e64809B757c47f942BEeA | 0x4c430944d20410a16d5cec69b0cb66541b00a817 |

### DeFi Tokens

| Token | Symbol | L1 Address (Ethereum) | L2 Address (Celo) |
|-------|--------|----------------------|-------------------|
| 1inch | 1INCH | 0x111111111117dC0aa78b770fA6A738034120C302 | 0x28ba8d26f5f6710f42170ee545a0c953ca4997b9 |
| Aave | AAVE | 0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9 | 0xF6A54aff8c97f7AF3CC86dbaeE88aF6a7AaB6288 |
| Across Protocol | ACX | 0x44108f0223A3C3028F5Fe7AEC7f9bb2E66beF82F | 0x3a05ef6467309f388f90bcc3d79a522e6c39fabb |
| Chainlink | LINK | 0x514910771af9ca656af840dff83e8264ecf986ca | 0xf630876008a4ed9249fb4cac978ba16827f52e91 |
| Curve DAO | CRV | 0xD533a949740bb3306d119CC777fa900bA034cd52 | 0x75184c282e55a7393053f0b8F4F3E7BeAE067fdC |
| PoolTogether | POOL | 0x0cec1a9154ff802e7934fc916ed7ca50bde6844e | 0xe00892b8636f0c7450177f89717539d656d870fb |
| Rocket Pool | RPL | 0xD33526068D116cE69F19A9ee46F0bd304F21A51f | 0x73a363ed1526f5e02be99f51c59400a2c508312c |

### Governance Tokens

| Token | Symbol | L1 Address (Ethereum) | L2 Address (Celo) |
|-------|--------|----------------------|-------------------|
| Uniswap | UNI | 0x1f9840a85d5af5bf1d1762f925bdaddc4201f984 | 0xeE571697998ec64e32B57D754D700c4dda2f2a0e |
| Maker | MKR | 0x9f8f72aa9304c8b593d555f12ef6589cc3a579a2 | 0x918b13745de61380d5d3efddf51244c369f101d5 |
| Lido DAO | LDO | 0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32 | 0x6981f932c2ec5f9e15d44d7ef46859a133f544dd |
| UMA | UMA | 0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828 | 0x4672ecbd03a1f93dd67310caecd3a8ef6397e72a |
| Gitcoin | GTC | 0xde30da39c46104798bb5aa3fe8b9e0e1f348163f | 0xa80e318dc786c58b8bcb692579764f56f89ab27e |
| Worldcoin | WLD | 0x163f8C2467924be0ae7B5347228CABF260318753 | 0x88c400d871829e381b53b55eee79145b4287461a |

### Commodity Tokens

| Token | Symbol | L1 Address (Ethereum) | L2 Address (Celo) |
|-------|--------|----------------------|-------------------|
| Tether Gold | XAUt | 0x68749665FF8D2d112Fa859AA293F07A622782F38 | 0x3776228836bfcfc87cac36c28830b67759c02707 |

## Celo Native Tokens

| Token | Symbol | Address | Decimals |
|-------|--------|---------|----------|
| Celo | CELO | Native | 18 |
| Celo (wrapped) | CELO | 0x471EcE3750Da237f93B8E339c536989b8978a438 | 18 |
| Mento Dollar | USDm | 0x765de816845861e75a25fca122bb6898b8b1282a | 18 |
| Mento Euro | EURm | 0xd8763cba276a3738e6de85b4b3bf5fded6d6ca73 | 18 |

## Additional Stablecoins on Celo

These stablecoins are available on Celo via various bridges:

| Token | Symbol | Address (Celo) | Decimals |
|-------|--------|----------------|----------|
| USD Coin | USDC | 0xcebA9300f2b948710d2653dD7B07f33A8B32118C | 6 |
| Tether USD | USDT | 0x48065fbbe25f71c9282ddf5e1cd6d6a887483d5e | 6 |

## Notes

- All bridged tokens maintain the same decimal precision as L1
- Always verify addresses on Celoscan before interacting
- L2 WETH on Celo is the canonical wrapped ETH for DeFi interactions
- Native bridge uses OP Stack standard bridge contracts
