---
name: jisu-cell
description: 使用极速数据基站查询 API，通过移动/联通/电信基站参数查询粗略位置（经纬度与地址）。
metadata: { "openclaw": { "emoji": "📶", "requires": { "bins": ["python3"], "env": ["JISU_API_KEY"] }, "primaryEnv": "JISU_API_KEY" } }
---

## 极速数据基站查询（Jisu Cell）

基于 [基站查询 API](https://www.jisuapi.com/api/cell/) 的 OpenClaw 技能。

使用技能前需要申请数据，申请地址：https://www.jisuapi.com/api/cell/

通过 CELLID 和 LAC 等参数获取基站的大致位置，包括经纬度、地址和精度。

支持移动、联通、电信三网基站查询，适合对话中做「粗定位」或结合其它位置服务（如经纬度反查地址、天气查询等）。

## 环境变量配置

```bash
# Linux / macOS
export JISU_API_KEY="your_appkey_here"

# Windows PowerShell
$env:JISU_API_KEY="your_appkey_here"
```

## 脚本路径

脚本文件：`skills/cell/cell.py`

## 使用方式

当前脚本只封装一个接口：`/cell/query`。

### 基站查询（/cell/query）

```bash
python3 skills/cell/cell.py '{"mnc":"0","lac":"22709","cellid":"39205","sid":"","nid":""}'
```

其中：

- `mnc`: 移动网络代码，**0 为移动，1 为联通**（电信场景可按极速数据文档传相应参数）
- `lac`: 小区号（十进制）
- `cellid`: 基站号（十进制）
- `sid`, `nid`: 电信制式下使用的系统/网络识别码（可选，按需填写）

请求 JSON 示例：

```json
{
  "mnc": "0",
  "lac": "22709",
  "cellid": "39205",
  "sid": "",
  "nid": ""
}
```

### 请求参数

| 字段名 | 类型   | 必填 | 说明                                                                        |
|--------|--------|------|-----------------------------------------------------------------------------|
| mnc    | string | 是   | 移动网络代号，移动 0，联通 1（电信可根据运营商编码填写）                   |
| lac    | string | 是   | 小区号，十进制表示。移动/联通需填写 `mnc`、`lac`、`cellid`                  |
| cellid | string | 是   | 基站号，十进制表示。电信对应 `bid`，电信场景一般搭配 `sid`、`nid` 使用     |
| sid    | string | 否   | 系统识别码（CDMA 电信，按城市唯一）                                        |
| nid    | string | 否   | 网络识别码（CDMA 电信，每个地级市可能有 1–3 个）                           |

脚本会校验 `mnc`、`lac`、`cellid` 为必填，其余字段原样透传给接口。

## 返回结果示例

脚本直接输出接口的 `result` 字段，结构与官网示例一致，例如（来自
[极速数据基站文档](https://www.jisuapi.com/api/cell/)）：

```json
{
  "lat": "30.28195000",
  "lng": "120.10932159",
  "addr": "浙江省杭州市西湖区古荡街道益乐路36-1号,益乐路与华星里街路口西北11.02米",
  "accuracy": "100"
}
```

字段说明：

- `lat` / `lng`：基站对应位置的纬度 / 经度（GCJ-02 或相关坐标系）
- `addr`：粗略地址描述
- `accuracy`：精度（米），值越小表示位置越精确

## 常见错误码

来自 [极速数据基站文档](https://www.jisuapi.com/api/cell/) 的业务错误码：

| 代号 | 说明     |
|------|----------|
| 201  | SID 为空 |
| 202  | NID 为空 |
| 210  | 没有信息 |

（注意：SID/NID 主要用于电信 CDMA 场景，移动/联通一般无需填写。）

系统错误码：

| 代号 | 说明                     |
|------|--------------------------|
| 101  | APPKEY 为空或不存在     |
| 102  | APPKEY 已过期           |
| 103  | APPKEY 无请求此数据权限 |
| 104  | 请求超过次数限制         |
| 105  | IP 被禁止               |
| 106  | IP 请求超过限制         |
| 107  | 接口维护中               |
| 108  | 接口已停用               |

## 在 OpenClaw 中的推荐用法

1. 用户问题示例：「这个基站（mnc=0, lac=22709, cellid=39205）大概在什么位置？」  
2. 代理构造 JSON：`{"mnc":"0","lac":"22709","cellid":"39205"}` 并调用：  
   `python3 skills/cell/cell.py '{"mnc":"0","lac":"22709","cellid":"39205"}'`。  
3. 从返回结果中读取 `lat`、`lng` 和 `addr`，将经纬度和人类可读地址总结给用户。  
4. 如需进一步反查周边信息，可将经纬度再传给经纬度地址转换、天气、地图等其他技能组合使用。  

