// cdp.js - Simple CDP HTTP client using fetch&#10;&#10;async function cdp(endpoint, options = {}) {&#10;  const url = `http://localhost:9222${endpoint}`;&#10;  const resp = await fetch(url, options);&#10;  if (!resp.ok) throw new Error(`CDP error: ${resp.status}`);&#10;  return resp.json ? await resp.json() : await resp.text();&#10;}&#10;&#10;// CLI example: node scripts/cdp.js list&#10;if (require.main === module) {&#10;  const args = process.argv.slice(2);&#10;  const path = args[0] || &#39;/json&#39;;&#10;  cdp(path).then(console.log).catch(console.error);&#10;}&#10;&#10;module.exports = { cdp };