# Privacy and Compliance

## Regulatory Landscape

| Regulation | Scope | Key Requirements |
|------------|-------|------------------|
| **GDPR** | EU residents | Consent, data subject rights, DPO, breach notification |
| **CCPA/CPRA** | California residents | Opt-out of sale, access rights, deletion |
| **HIPAA** | US healthcare | PHI protection, BAAs, minimum necessary |
| **SOC 2** | Service providers | Security, availability, confidentiality controls |
| **PCI-DSS** | Payment data | Cardholder data protection, network security |

## Privacy by Design Principles

1. **Proactive not reactive** — Prevent problems before they occur
2. **Privacy as default** — No action required for privacy protection
3. **Privacy embedded** — Built into systems, not bolted on
4. **Full functionality** — Privacy and utility, not trade-offs
5. **End-to-end security** — Lifecycle protection
6. **Visibility and transparency** — Verifiable practices
7. **User-centric** — Respect individual interests

## Data Subject Rights Workflow

### Right to Access
1. Verify identity
2. Locate all data across systems
3. Compile in portable format
4. Deliver within deadline (30 days GDPR)

### Right to Deletion
1. Verify identity and right applies
2. Identify all data locations including backups
3. Delete or anonymize
4. Confirm to data subject
5. Document for audit trail

### Right to Rectification
1. Verify identity
2. Update across all systems
3. Propagate to third parties if shared
4. Confirm completion

## Compliance Implementation

### Phase 1: Assessment
- Data inventory (what, where, why)
- Lawful basis mapping
- Gap analysis against regulations
- Risk prioritization

### Phase 2: Foundation
- Privacy notices updated
- Consent management deployed
- Data subject request process
- Vendor assessment process

### Phase 3: Operations
- Privacy impact assessments routine
- Training programs
- Incident response tested
- Audit schedule established

## Consent Management

| Consent Type | When Required | Granularity |
|--------------|---------------|-------------|
| **Explicit** | Sensitive data, marketing | Specific purpose |
| **Implied** | Necessary for service | Bundled acceptable |
| **Opt-out** | CCPA sale of data | Category level |

### Technical Requirements
- Consent timestamp and version
- Easy withdrawal mechanism
- Preference center
- Audit trail of changes
- Integration with data systems for enforcement
