---
name: CDN
slug: cdn
description: Configure, optimize, and troubleshoot CDN deployments with caching strategies, security hardening, and multi-provider management.
---

## When to Use

User wants to set up, optimize, or debug a CDN. Covers provider selection, caching, security, and performance monitoring.

## Quick Reference

| Topic | File |
|-------|------|
| Provider comparison & CLIs | `providers.md` |
| Security hardening | `security.md` |
| Caching strategies | `caching.md` |
| Troubleshooting | `troubleshooting.md` |

## Core Capabilities

1. **Provider selection** — Compare Cloudflare, CloudFront, Bunny, Fastly based on use case, traffic, budget
2. **Cache configuration** — Set optimal cache-control headers, TTLs, cache keys
3. **Security setup** — SSL/TLS, WAF rules, DDoS protection, origin shielding
4. **Performance monitoring** — Cache hit ratios, TTFB, regional latency
5. **Invalidation** — Purge strategies, CI/CD integration, tagged invalidation
6. **Cost optimization** — Bandwidth analysis, tier recommendations, multi-CDN strategies
7. **Troubleshooting** — Debug cache misses, stale content, origin overload

## Cache-Control Checklist

Before deploying, verify:
- [ ] Hashed assets (JS/CSS) → `Cache-Control: public, max-age=31536000, immutable`
- [ ] HTML pages → Short TTL or `no-cache` with revalidation
- [ ] Images → Long TTL with content-based URLs or versioning
- [ ] API responses → Usually `no-store` unless explicitly cacheable
- [ ] User-specific content → `private` or `no-store`

## Security Checklist

- [ ] TLS 1.2+ enforced, weak ciphers disabled
- [ ] HSTS enabled with appropriate max-age
- [ ] Origin IPs hidden, authenticated origin pulls configured
- [ ] Rate limiting on sensitive endpoints (login, API)
- [ ] Security headers: CSP, X-Frame-Options, X-Content-Type-Options

## Common Mistakes

- Caching user-specific responses (auth tokens, personalized content)
- Using `max-age` without `immutable` for versioned assets
- Purging entire cache instead of targeted paths
- Ignoring `Vary` headers (cache poisoning risk)
- Origin not rejecting direct access (bypassing CDN protections)

## Decision: Do I Need a CDN?

Ask about:
- Geographic distribution of users
- Current page load times and Core Web Vitals
- Static vs dynamic content ratio
- Traffic volume and patterns

If users are mostly local and traffic is low → CDN may add complexity without benefit.
If global users OR heavy static assets OR need DDoS protection → CDN adds value.
