# Retention and Churn Prevention

## Churn Categories

### Controllable Churn
- **Value not realized** — Didn't achieve expected outcomes
- **Poor onboarding** — Never got to first value
- **Relationship failure** — Champion left, no backup
- **Product gaps** — Missing critical features
- **Service issues** — Support or delivery problems

### Partially Controllable
- **Budget cuts** — Can sometimes save with discounts or downgrades
- **Strategic shift** — New leadership, new priorities
- **Consolidation** — Vendor reduction initiatives

### Uncontrollable
- **Company failure** — Bankruptcy, acquisition, shutdown
- **Complete pivot** — Business model change
- **Regulatory** — Compliance requirements

Focus energy on controllable churn first.

## Save Play Framework

### Red Account Intervention
1. **Immediate executive outreach** — Show urgency and importance
2. **Root cause discovery** — What's really driving the risk?
3. **Value demonstration** — Concrete ROI they've received
4. **Resolution plan** — Specific actions with dates
5. **Executive alignment** — Get commitment from their leadership

### Save Offer Hierarchy
1. **Value-first** — Training, services, success resources
2. **Timeline adjustment** — Extend contract at same terms
3. **Scope modification** — Downgrade vs cancel
4. **Pricing last resort** — Discount only if nothing else works

Never lead with price. It devalues the product and trains customers to threaten churn.

## Renewal Process

### 120 Days Out
- Health score review
- Usage analysis prepared
- Success stories documented
- Expansion opportunities identified
- Risk factors flagged

### 90 Days Out
- Renewal conversation initiated
- Value review meeting scheduled
- Decision-maker confirmed
- Timeline and process aligned

### 60 Days Out
- Proposal delivered
- Objections addressed
- Negotiation if needed
- Legal/procurement engaged

### 30 Days Out
- Contract finalized
- Signatures obtained
- Celebration and next phase planning

## Churn Analysis

### Win/Loss Reviews
For every churned customer:
- **Primary reason** — One main cause
- **Contributing factors** — What else mattered
- **Controllable?** — Could we have prevented it
- **Warning signs** — What did we miss
- **Process gaps** — What should change

### Churn Cohort Analysis
- **By segment** — Enterprise vs SMB patterns
- **By tenure** — First year vs established
- **By acquisition source** — Channel quality differences
- **By CSM** — Individual performance patterns
- **By product line** — Product-market fit signals

## Retention Metrics

| Metric | Formula | Target |
|--------|---------|--------|
| **Logo Retention** | (Customers End - New) / Customers Start | >90% |
| **Gross Revenue Retention** | Retained Revenue / Starting Revenue | >85% |
| **Net Revenue Retention** | (Retained + Expansion) / Starting | >100% |

GRR shows retention capability. NRR shows growth efficiency.

## Proactive Retention Tactics

### High-Touch Accounts
- Quarterly business reviews with executives
- Annual success planning
- Regular health check conversations
- Executive sponsor program

### Tech-Touch Accounts
- Automated health alerts
- In-app engagement campaigns
- Self-service success resources
- Community-driven support

### All Accounts
- Product adoption campaigns
- Customer advisory board
- User conferences and events
- Success certification programs
