# Customer Success Operations

## Team Structure

### By Company Stage

**Seed (1-50 customers)**
- Founder-led CS
- Maybe 1 CSM hire
- Generalist approach

**Series A (50-200 customers)**
- CS Manager + 2-3 CSMs
- Basic segmentation
- First playbooks

**Series B (200-500 customers)**
- CS Director
- Segment-specialized CSMs
- CS Ops role
- Scaled programs

**Series C+ (500+ customers)**
- VP/CCO
- Enterprise, Mid-market, SMB teams
- Dedicated onboarding team
- CS Ops team
- Scaled and digital CS

### Role Specialization

| Role | Focus | Ratio |
|------|-------|-------|
| Enterprise CSM | High-touch, strategic | 1:10-20 accounts |
| Mid-market CSM | Balanced touch | 1:30-50 accounts |
| SMB CSM | Scaled, efficient | 1:100-200 accounts |
| Onboarding Specialist | Time-to-value | Project-based |
| CS Ops | Process, tools, data | 1 per 5-8 CSMs |
| Renewal Manager | Contract execution | Volume-based |

## Segmentation Models

### By Revenue
| Tier | ARR Range | Service Model |
|------|-----------|---------------|
| Enterprise | >$100K | Named CSM, QBRs, executive sponsor |
| Mid-market | $25-100K | Named CSM, regular check-ins |
| SMB | <$25K | Pooled CSM, digital-first |

### By Potential
Factor in:
- Company size and growth
- Use case expansion potential
- Strategic value (brand, references)
- Industry or vertical importance

### By Health
- **Green** — Maintain, expand
- **Yellow** — Increase touch, address issues
- **Red** — Save team intervention

## Playbooks

### Essential Playbooks
1. **Onboarding** — First 30/60/90 days
2. **Adoption** — Feature activation sequences
3. **At-risk intervention** — Red account response
4. **Renewal** — Process and timing
5. **Expansion** — Identification and handoff
6. **Escalation** — When and how to escalate

### Playbook Components
- **Trigger** — What initiates the playbook
- **Owner** — Who's responsible
- **Steps** — Specific actions
- **Timeline** — Expected duration
- **Outcomes** — Success criteria
- **Escalation** — When to escalate

## Tech Stack

### Essential Tools
| Category | Purpose | Examples |
|----------|---------|----------|
| CS Platform | Health, playbooks, tracking | Gainsight, ChurnZero, Totango |
| CRM | Customer data, pipeline | Salesforce, HubSpot |
| Communication | Email sequences, in-app | Intercom, Customer.io |
| Analytics | Usage data, product analytics | Amplitude, Mixpanel, Pendo |
| Survey | NPS, CSAT collection | Delighted, Wootric |

### Build vs Buy
- **Build** — Only if CS is core differentiator and you have engineering capacity
- **Buy** — Almost always better; focus CS team on customers, not tools

## Capacity Planning

### CSM Capacity Formula
```
Required CSMs = (Customers × Avg Hours per Customer) / Available Hours per CSM

Example:
- 200 customers
- 5 hours/month average
- 140 available hours/CSM
= 200 × 5 / 140 = 7.1 CSMs needed
```

### Scaling Triggers
Hire when:
- CSMs consistently over capacity (>110%)
- Health scores declining due to coverage
- Renewal rates dropping
- Expansion opportunities missed
- CSM burnout/turnover increasing

## Compensation

### Base + Variable Mix
| Level | Base | Variable | Variable Tied To |
|-------|------|----------|------------------|
| CSM | 70-80% | 20-30% | GRR, NPS, adoption |
| Senior CSM | 65-75% | 25-35% | GRR, NRR, expansion |
| CS Manager | 60-70% | 30-40% | Team metrics |

### Variable Components
- **Renewal rate** — Primary metric
- **Expansion revenue** — Growth contribution
- **Health scores** — Leading indicator
- **NPS** — Customer satisfaction
- **Adoption metrics** — Product stickiness

Align compensation with what you want CSMs to prioritize.
