# Expansion Revenue

## Expansion Types

### Upsell
- **Tier upgrades** — Basic to Pro to Enterprise
- **User expansion** — More seats/licenses
- **Capacity increases** — Storage, API calls, volume
- **Premium features** — Add-on modules

### Cross-sell
- **Additional products** — Complementary solutions
- **New use cases** — Different departments, workflows
- **Platform expansion** — Additional integrations

### Price Increases
- **Annual increases** — Built into contract
- **Value-based repricing** — Tied to delivered outcomes
- **Market adjustments** — Competitive positioning

## Expansion Signals

### Strong Buying Signals
- Hitting usage limits
- Asking about features in higher tiers
- New stakeholders requesting access
- Expanding to new departments
- Proactive ROI discussions

### Moderate Signals
- High product engagement
- Positive NPS scores
- Reference willingness
- Training requests for new teams
- Integration interest

### Timing Indicators
- Budget cycle alignment
- Organizational changes (growth mode)
- Strategic initiatives announced
- Competitive displacement opportunity
- Contract milestone approaching

## Expansion Playbook

### Discovery Phase
1. **Usage analysis** — Where are they bumping limits?
2. **Stakeholder mapping** — Who else could benefit?
3. **Business context** — Company growth, initiatives, challenges
4. **Current success** — Documented wins and ROI

### Positioning Phase
1. **Value connection** — Link expansion to their goals
2. **Use case development** — Specific scenarios and outcomes
3. **ROI projection** — Expected return on additional investment
4. **Risk mitigation** — Address concerns proactively

### Execution Phase
1. **Champion alignment** — Internal advocate prepared
2. **Proposal delivery** — Clear scope and pricing
3. **Stakeholder management** — Decision-maker engagement
4. **Negotiation** — Terms that work for both sides

## Land and Expand Model

### Land Strategy
- Start with single team or use case
- Prove value quickly (under 90 days)
- Document success metrics
- Build champion relationship

### Expand Triggers
| Milestone | Expansion Motion |
|-----------|------------------|
| 90 days success | Adjacent team introduction |
| Power user emergence | Department expansion |
| Executive visibility | Strategic account planning |
| Reference willingness | Case study + expansion |

### Expansion Math
```
Initial Deal: $50K
Year 1 Expansion: 20% = $60K
Year 2 Expansion: 20% = $72K
Year 3 Expansion: 20% = $86K

3-Year Value: $268K vs $150K (flat)
```

## CSM vs Sales Ownership

| Motion | Primary Owner | Partner |
|--------|--------------|---------|
| Renewal (flat) | CSM | — |
| Small upsell (<20%) | CSM | Sales informed |
| Large upsell (>20%) | Sales | CSM supports |
| Cross-sell (new product) | Sales | CSM introduces |
| Strategic expansion | Sales | CSM relationship |

Clear ownership prevents confusion and dropped opportunities.

## Expansion Metrics

| Metric | What It Measures |
|--------|------------------|
| **Expansion Rate** | % of customers who expanded |
| **Expansion Revenue** | Total revenue from expansion |
| **Time to Expand** | Average days from land to first expand |
| **Expansion Efficiency** | Expansion revenue / CS cost |
| **NRR** | Net retention including expansion |

Target NRR > 110% means growth without new logos.
