# Revenue Strategy

## Revenue Diversification

### Why Diversify?
- **Risk reduction** — Single source dependency is vulnerability
- **Growth ceiling** — Current channels may saturate
- **Margin optimization** — Different channels have different economics
- **Competitive moat** — Multiple revenue streams harder to attack

### Customer Concentration Risk

| Concentration | Risk Level | Action |
|---------------|------------|--------|
| Top customer >30% | Critical | Immediate diversification priority |
| Top 3 customers >50% | High | Accelerate new customer acquisition |
| Top 10 customers >80% | Moderate | Build pipeline depth |
| No customer >10% | Low | Maintain healthy balance |

## Revenue Models

### Direct vs Indirect

**Direct sales:**
- Higher margins
- Customer relationship ownership
- Slower to scale
- Higher CAC

**Channel/Partner sales:**
- Lower margins
- Faster reach
- Less control
- Depends on partner priorities

### Pricing Models

| Model | Best For | Watch Out |
|-------|----------|-----------|
| **Subscription** | Predictable value, ongoing use | Churn, activation |
| **Usage-based** | Variable consumption | Revenue unpredictability |
| **Per-seat** | Team tools, collaboration | Seat consolidation |
| **Transaction fee** | Marketplaces, payments | Volume dependency |
| **Hybrid** | Complex products | Complexity, confusion |

## Channel Strategy

### Channel Types

1. **Direct sales** — Your team, high touch
2. **Inside sales** — Your team, lower touch
3. **Self-serve** — Product-led, no human
4. **Partners** — Resellers, distributors
5. **Affiliates** — Referral commission
6. **Marketplaces** — Platforms (AWS, Salesforce, etc.)

### Channel Mix Decisions

Consider for each channel:
- Customer acquisition cost
- Average deal size
- Sales cycle length
- Support requirements
- Margin after channel costs
- Control over customer relationship

### Multi-Channel Conflict

Prevent channel cannibalization:
- Clear segmentation rules (by size, geography, vertical)
- Deal registration systems
- Protected accounts
- Differentiated offerings by channel
- Transparent conflict resolution

## Pricing Strategy

### Pricing Principles
- **Value-based** — Price based on customer value, not cost
- **Segment-specific** — Different prices for different segments
- **Simple to understand** — Complexity kills deals
- **Room to negotiate** — Build in discount capacity
- **Regular review** — Markets change, pricing should too

### Price Increase Playbook

1. **Communicate value first** — Before announcing increase
2. **Advance notice** — 60-90 days minimum
3. **Grandfather loyal customers** — Temporarily or permanently
4. **Justify with improvements** — What they get for more
5. **Offer alternatives** — Downgrade options
6. **Personal outreach** — Big accounts hear from humans

## Revenue Operations

### Pipeline Management
- Stage definitions clear and consistent
- Probability by stage based on historical data
- Regular pipeline reviews
- Aging deal policies
- Win/loss tracking and analysis

### Forecasting
- Bottoms-up (rep-level commits) + tops-down (trend analysis)
- Track forecast accuracy over time
- Segment forecasts (new vs expansion vs renewal)
- Include churn in net revenue forecast

### Metrics Dashboard

Track weekly:
- Pipeline value by stage
- Conversion rates between stages
- Average deal size
- Sales cycle length
- Win rate
- Revenue by channel/segment
- Churn and expansion revenue
