# Partnership Frameworks

## Partnership Types

| Type | Description | When to Use |
|------|-------------|-------------|
| **Distribution** | Partner sells/promotes your product | Need reach without building sales team |
| **Technology** | Integration between products | Customers use both, want seamless experience |
| **Co-marketing** | Joint campaigns, content | Shared audience, complementary offerings |
| **Strategic** | Deep operational alignment | Long-term market positioning |
| **Channel** | Resellers, affiliates, referrals | Scale customer acquisition |

## Partner Evaluation Criteria

Before pursuing any partnership:
- **Strategic alignment** — Do their goals complement yours?
- **Capability match** — Can they actually deliver?
- **Cultural fit** — Will teams work well together?
- **Economic viability** — Does the math work for both sides?
- **Reputation** — Would association enhance your brand?

## Partnership Lifecycle

### 1. Identification
- Map target partner universe by type
- Score by strategic value and accessibility
- Identify warm introductions through network
- Research their partnership history and preferences

### 2. Outreach
- Lead with value proposition for them
- Show you've done homework on their business
- Propose specific collaboration, not vague "partnership"
- Find the right contact (BD, partnerships, exec sponsor)

### 3. Negotiation
- Start with term sheet on key points
- Define success metrics upfront
- Address exclusivity carefully
- Build in review periods

### 4. Launch
- Joint kickoff with both teams
- Clear owners and communication channels
- Shared dashboard for metrics
- Regular check-in cadence

### 5. Optimization
- Quarterly business reviews
- Identify expansion opportunities
- Address friction points early
- Document learnings for future partnerships

## Red Flags

- Partner pushes for exclusivity without commitment
- No clear owner on their side
- Misaligned timelines or urgency
- History of failed partnerships
- Demands that compromise your core business

## Partnership Agreement Essentials

- Scope and responsibilities
- Economic terms and payment timing
- Success metrics and reporting
- Term length and renewal conditions
- Exit clauses and IP ownership
- Dispute resolution process
