# Market Expansion Playbooks

## Expansion Decision Framework

### Should You Expand?

Answer these before committing resources:

1. **Is current market saturated?**
   - If <30% market penetration, focus on core market first
   - Expansion is expensive; maximize existing opportunity

2. **Do you have product-market fit?**
   - Expansion multiplies both success and failure
   - Fix retention before expanding reach

3. **Is there validated demand?**
   - Customer requests, inbound from new market
   - Competitor success in target market
   - Market research showing unmet need

4. **Can you resource it properly?**
   - Half-committed expansion fails
   - Need dedicated team, not side project

## Expansion Types

### Geographic Expansion

**Validation before commitment:**
- Run ads to test demand (landing page, waitlist)
- Interview 20+ potential customers in market
- Analyze competitor presence and positioning
- Understand regulatory requirements

**Entry options by investment:**
| Approach | Investment | Speed | Control |
|----------|------------|-------|---------|
| Distributor | Low | Fast | Low |
| Local partner | Medium | Medium | Medium |
| Direct presence | High | Slow | High |

**Localization checklist:**
- [ ] Language translation (not just words, context)
- [ ] Payment methods (local preferences)
- [ ] Pricing (purchasing power parity)
- [ ] Legal compliance (data, consumer protection)
- [ ] Support hours and language
- [ ] Marketing channels (different platforms dominate)

### Vertical Expansion

Moving into adjacent industries:

1. **Identify transferable value** — What works across verticals?
2. **Map differences** — What customization is required?
3. **Find beachhead customers** — Start with design partners
4. **Build vertical expertise** — Hire from the industry
5. **Create reference cases** — Success stories are currency

### Upmarket/Downmarket Expansion

**Going upmarket (SMB → Enterprise):**
- Longer sales cycles
- More stakeholders
- Security/compliance requirements
- Implementation support needed
- Different pricing model

**Going downmarket (Enterprise → SMB):**
- Self-serve required
- Lower touch support
- Price sensitivity
- Simpler product version
- Marketing-led acquisition

## Beachhead Strategy

Don't try to win everywhere at once:

1. Pick one segment in new market
2. Achieve dominance in that segment
3. Use as proof point for expansion
4. Adjacent segments reference your success
5. Expand systematically

**Beachhead criteria:**
- Small enough to dominate with available resources
- Big enough to matter and get noticed
- Connected to larger opportunity
- Customers willing to be references

## Expansion Metrics

Track separately from core business:
- Customer acquisition cost (CAC) by market
- Time to first revenue
- Retention vs core market
- Net promoter score by region
- Revenue per customer
- Support ticket ratio

## Common Expansion Failures

- **Too early** — Expanding before product-market fit
- **Under-resourced** — Part-time attention to full-time problem
- **Copy-paste** — Assuming what works at home works abroad
- **Wrong partner** — Rushed partnership selection
- **Ignored signals** — Continuing despite negative data
