# Deal Negotiation Tactics

## Pre-Negotiation Preparation

### Know Your Position
- **BATNA** — Best Alternative To Negotiated Agreement
  - What happens if this deal doesn't close?
  - Stronger BATNA = more leverage
- **Walk-away point** — Define before entering room
- **Target outcome** — What does "good" look like?
- **Opening position** — Where to start (with justification)

### Know Their Position
- **Their constraints** — Budget, timeline, internal politics
- **Their alternatives** — Who else are they talking to?
- **Their decision process** — Who decides? Who influences?
- **Their success metrics** — What do they need to show internally?

### Preparation Checklist
- [ ] Researched their company and recent news
- [ ] Identified key stakeholders and their priorities
- [ ] Prepared data supporting your position
- [ ] Anticipated their objections
- [ ] Defined your non-negotiables
- [ ] Listed tradeable items for concessions

## Negotiation Tactics

### Opening
- **Anchor high** — First number shapes the range
- **Listen first** — Let them reveal priorities
- **Ask questions** — Understand before proposing
- **Frame value** — Lead with what they get, not what you want

### Middle
- **Trade, don't give** — Every concession should get something
- **Package issues** — Don't negotiate point by point
- **Use silence** — Uncomfortable pauses reveal information
- **Summarize progress** — Keep momentum visible

### Closing
- **Create urgency** (legitimate) — Deadlines, limited availability
- **Final offer framing** — "This is as far as we can go because..."
- **Get verbal, then written** — Handshake before contract
- **Document immediately** — Memory differs after the room

## Common Negotiation Scenarios

### They Have More Leverage
- Focus on relationship and long-term value
- Find creative terms (exclusivity, case study rights, etc.)
- Emphasize unique value you provide
- Be willing to walk — desperation is visible

### They're Aggressive
- Stay calm — emotion clouds judgment
- Focus on interests, not positions
- Name the tactic — "It seems like we're at an impasse"
- Take breaks when needed

### Multiple Stakeholders
- Map the buying committee early
- Find your champion
- Address each stakeholder's concerns
- Align timing across approvals

### Competitive Deal
- Differentiate on value, not just price
- Understand what competitor offers
- Create switching costs early
- Don't trash talk — focus on your strengths

## Term Sheet Essentials

### Economics
- Payment amount and structure
- Payment timing and triggers
- Performance-based components
- Minimum commitments
- Price escalation clauses

### Scope
- Exactly what's included
- What's explicitly excluded
- Geographic/market limitations
- Exclusivity terms

### Duration
- Initial term length
- Renewal conditions
- Notice periods
- Auto-renewal or opt-in

### Protection
- Intellectual property ownership
- Confidentiality terms
- Non-compete/non-solicit
- Indemnification
- Liability caps

### Exit
- Termination for convenience
- Termination for cause
- Wind-down obligations
- Data/transition requirements

## Red Flags in Deals

- Rushed timeline with no clear reason
- Reluctance to put terms in writing
- Constantly changing requirements
- Decision maker never available
- Terms that seem too good
- Pressure to skip due diligence
