# NIP-3400: Catallax Contract Work Protocol

Draft NIP for decentralized contract work on Nostr.
Source: https://github.com/nostr-protocol/nips/pull/1714

## Roles

- **Patron**: Creates tasks, funds escrow, assigns Free Agents
- **Arbiter**: Escrow agent — advertises services, judges work, handles payments
- **Free Agent**: Applies for tasks, delivers work, gets paid

## Event Kinds

### Kind 33400: Arbiter Announcement (addressable replaceable)

Advertises arbiter services.

```json
{
  "kind": 33400,
  "content": "{\"name\":\"Service Title\",\"about\":\"Details\",\"policy_text\":\"...\",\"policy_url\":\"...\"}",
  "tags": [
    ["d", "<service-identifier>"],
    ["p", "<arbiter-pubkey>"],
    ["fee_type", "flat|percentage"],
    ["fee_amount", "<sats or 0.0-1.0>"],
    ["min_amount", "<optional min sats>"],
    ["max_amount", "<optional max sats>"],
    ["t", "<category>"],
    ["r", "<details-url>"]
  ]
}
```

### Kind 33401: Task Proposal (addressable replaceable)

Defines a work task with requirements and payment.

```json
{
  "kind": 33401,
  "content": "{\"title\":\"...\",\"description\":\"...\",\"requirements\":\"...\",\"deadline\":1234567890}",
  "tags": [
    ["d", "<task-identifier>"],
    ["p", "<patron-pubkey>"],
    ["p", "<arbiter-pubkey>"],
    ["p", "<worker-pubkey>"],
    ["a", "33400:<arbiter-pubkey>:<arbiter-d-tag>", "<relay>"],
    ["amount", "<sats>"],
    ["t", "<category>"],
    ["status", "proposed|funded|in_progress|submitted|concluded"],
    ["funding_type", "patron|crowdfunding"],
    ["e", "<zap-receipt-id>", "<relay>", "zap"],
    ["r", "<details-url>"]
  ]
}
```

**Status lifecycle:** proposed → funded → in_progress → submitted → concluded

### Kind 3402: Task Conclusion (regular, not replaceable)

Documents task resolution.

```json
{
  "kind": 3402,
  "content": "{\"resolution_details\":\"Description of outcome\"}",
  "tags": [
    ["e", "<payout-zap-receipt-id>"],
    ["e", "<task-proposal-event-id>"],
    ["p", "<patron-pubkey>"],
    ["p", "<arbiter-pubkey>"],
    ["p", "<worker-pubkey>"],
    ["resolution", "successful|rejected|cancelled|abandoned"],
    ["a", "33401:<patron-pubkey>:<task-d-tag>", "<relay>"]
  ]
}
```

## Workflow

1. Arbiter publishes kind 33400 (service announcement)
2. Patron publishes kind 33401 with status=proposed
3. Patron coordinates with arbiter out-of-band, funds escrow
4. Patron updates 33401: status=funded, adds zap receipt e-tag
5. Free Agent applies, Patron assigns → status=in_progress, adds worker p-tag
6. Free Agent delivers work → status=submitted
7. Arbiter judges → publishes kind 3402 (conclusion)
8. Patron updates 33401: status=concluded

## Relays

Tasks are found on standard Nostr relays. Common ones:
- wss://relay.damus.io
- wss://nos.lol
- wss://relay.primal.net

## Links

- Protocol site: https://catallax.network
- Reference client: https://catallax-reference-client.netlify.app/catallax
- Client repo: https://github.com/vcavallo/catallax-reference-client
- NIP PR: https://github.com/nostr-protocol/nips/pull/1714
